/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.templates.CommandEventAction;
import net.citizensnpcs.api.npc.templates.CommandListExecutor;
import net.citizensnpcs.api.npc.templates.TemplateRegistry;
import net.citizensnpcs.api.npc.templates.TemplateWorkspace;
import net.citizensnpcs.api.npc.templates.TraitLoaderAction;
import net.citizensnpcs.api.npc.templates.YamlReplacementAction;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.NamespacedKey;

public class Template {
    private final List<Consumer<NPC>> actions = Lists.newArrayList();
    private final NamespacedKey key;

    private Template(NamespacedKey key) {
        this.key = key;
    }

    private void addAction(Consumer<NPC> action) {
        this.actions.add(action);
    }

    public void apply(NPC npc) {
        boolean respawn = npc.isSpawned();
        if (respawn) {
            npc.despawn(DespawnReason.PENDING_RESPAWN);
        }
        for (Consumer<NPC> action : this.actions) {
            action.accept(npc);
        }
        if (respawn) {
            npc.spawn(npc.getStoredLocation());
        }
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public static Template load(TemplateRegistry.TemplateErrorReporter errors, TemplateWorkspace workspace, NamespacedKey identifier, DataKey key) {
        Template template = new Template(identifier);
        if (key.keyExists("yaml_replace")) {
            template.addAction((Consumer)((Object)PersistenceLoader.load(YamlReplacementAction.class, key.getRelative("yaml_replace"))));
        }
        if (key.keyExists("traits")) {
            template.addAction(new TraitLoaderAction(errors, workspace, key.getRelative("traits")));
        }
        if (key.keyExists("commands")) {
            Template.loadCommands(template, workspace, key.getRelative("commands"));
        }
        return template;
    }

    private static void loadCommands(Template template, TemplateWorkspace workspace, DataKey key) {
        for (DataKey sub : key.getSubKeys()) {
            ArrayList commands = Lists.newArrayList((Iterable)Iterables.transform(sub.getIntegerSubKeys(), k -> k.getString("")));
            if (sub.name().equals("on_spawn")) {
                template.addAction(new CommandEventAction(NPCSpawnEvent.class, new CommandListExecutor(commands)));
                continue;
            }
            if (!sub.name().equals("on_template_apply")) continue;
            CommandListExecutor cle = new CommandListExecutor(commands);
            template.addAction(npc -> cle.accept((NPC)npc));
        }
    }
}

