/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.scripts.commands;

import com.denizenscript.clientizen.mixin.BillboardParticleAccessor;
import com.denizenscript.clientizen.objects.EntityTag;
import com.denizenscript.clientizen.objects.ItemTag;
import com.denizenscript.clientizen.objects.LocationTag;
import com.denizenscript.clientizen.objects.MaterialTag;
import com.denizenscript.clientizen.util.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.function.Predicate;
import net.minecraft.class_2223;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3940;
import net.minecraft.class_5707;
import net.minecraft.class_5709;
import net.minecraft.class_5716;
import net.minecraft.class_5743;
import net.minecraft.class_5745;
import net.minecraft.class_703;
import net.minecraft.class_7227;
import net.minecraft.class_7290;
import net.minecraft.class_7923;

public class ParticleCommand
extends AbstractCommand {
    public ParticleCommand() {
        this.setName("particle");
        this.setSyntax("particle [type:<particle>] [at:<location>] (velocity:<velocity>) (color:<color>) (duration:<duration>) (scale_multiplier:<#.#>) (data:<map>/raw_data:<data>)");
        this.setRequiredArguments(2, 7);
        this.autoCompile();
    }

    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("type:", Utilities.listRegistryKeys(class_7923.field_41180));
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="type") @ArgPrefixed String particleName, @ArgName(value="at") @ArgPrefixed LocationTag location, @ArgName(value="velocity") @ArgPrefixed @ArgDefaultNull LocationTag velocity, @ArgName(value="color") @ArgPrefixed @ArgDefaultNull ColorTag color, @ArgName(value="duration") @ArgPrefixed @ArgDefaultNull DurationTag duration, @ArgName(value="scale_multiplier") @ArgPrefixed @ArgDefaultNull ElementTag scaleMultiplier, @ArgName(value="data") @ArgPrefixed @ArgDefaultNull MapTag data, @ArgName(value="raw_data") @ArgPrefixed @ArgDefaultNull String rawData) {
        class_703 createdParticle;
        class_2394 particle;
        class_2396 type = (class_2396)class_7923.field_41180.method_63535(class_2960.method_12829((String)particleName));
        if (type == null) {
            Debug.echoError((String)("Invalid particle type specified: " + particleName + "."));
            return;
        }
        if (rawData != null) {
            try {
                class_2487 particleData = class_2522.method_67315((String)rawData);
                particle = (class_2394)type.method_29138().codec().parse(Utilities.registryOps(class_2509.field_11560), (Object)particleData).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)class_2223.field_51438).create(arg_0));
            }
            catch (CommandSyntaxException syntaxException) {
                Debug.echoError((String)("Invalid raw particle data '" + rawData + "' for particle of type '" + particleName + "': " + syntaxException.getMessage()));
                return;
            }
        } else if (type == class_2398.field_11217 || type == class_2398.field_35434 || type == class_2398.field_11206) {
            MaterialTag material = ParticleCommand.requireData(data, "material", MaterialTag.class, MaterialTag::isBlock, particleName, scriptEntry);
            particle = new class_2388(type, material.state);
        } else if (type == class_2398.field_11212) {
            ColorTag dustColor = ParticleCommand.requireData(data, "color", ColorTag.class, particleName, scriptEntry);
            ElementTag dustScale = ParticleCommand.requireData(data, "scale", ElementTag.class, ElementTag::isFloat, particleName, scriptEntry);
            particle = new class_2390(dustColor.asRGB(), dustScale.asFloat());
        } else if (type == class_2398.field_28276) {
            ColorTag fromColor = ParticleCommand.requireData(data, "from", ColorTag.class, particleName, scriptEntry);
            ColorTag toColor = ParticleCommand.requireData(data, "to", ColorTag.class, particleName, scriptEntry);
            ElementTag dustScale = ParticleCommand.requireData(data, "scale", ElementTag.class, ElementTag::isFloat, particleName, scriptEntry);
            particle = new class_5743(fromColor.asRGB(), toColor.asRGB(), dustScale.asFloat());
        } else if (type == class_2398.field_38003) {
            ElementTag roll = ParticleCommand.requireData(data, "roll", ElementTag.class, ElementTag::isFloat, particleName, scriptEntry);
            particle = new class_7227(roll.asFloat());
        } else if (type == class_2398.field_11218) {
            ItemTag item = ParticleCommand.requireData(data, "item", ItemTag.class, particleName, scriptEntry);
            particle = new class_2392(class_2398.field_11218, item.getStack());
        } else if (type == class_2398.field_28275) {
            class_5707 destination;
            if (data.containsKey("location")) {
                LocationTag sourceLoc = ParticleCommand.requireData(data, "location", LocationTag.class, particleName, scriptEntry);
                destination = new class_5707(sourceLoc.getBlockPos());
            } else if (data.containsKey("entity")) {
                EntityTag sourceEntity = ParticleCommand.requireData(data, "entity", EntityTag.class, particleName, scriptEntry);
                ElementTag yOffset = data.containsKey("y_offset") ? ParticleCommand.requireData(data, "y_offset", ElementTag.class, ElementTag::isFloat, particleName, scriptEntry) : null;
                destination = new class_5709(sourceEntity.getEntity(), yOffset != null ? yOffset.asFloat() : 0.0f);
            } else {
                throw new InvalidArgumentsRuntimeException("Invalid data '" + data.debuggable() + "<W>' for 'vibration' particle: must have either a block or entity destination.");
            }
            DurationTag travelTime = ParticleCommand.requireData(data, "arrival_time", DurationTag.class, particleName, scriptEntry);
            particle = new class_5745((class_5716)destination, travelTime.getTicksAsInt());
        } else if (type == class_2398.field_38357) {
            DurationTag delay = ParticleCommand.requireData(data, "delay", DurationTag.class, particleName, scriptEntry);
            particle = new class_7290(delay.getTicksAsInt());
        } else {
            particle = (class_2400)type;
        }
        try {
            createdParticle = class_310.method_1551().field_1713.method_3056(particle, location.getX(), location.getY(), location.getZ(), 0.0, 0.0, 0.0);
        }
        catch (Throwable throwable) {
            Debug.echoError((String)"Internal error when spawning particle, see stacktrace below:");
            Debug.echoError((Throwable)throwable);
            return;
        }
        if (velocity != null) {
            createdParticle.method_34753(velocity.getX(), velocity.getY(), velocity.getZ());
        }
        if (color != null && createdParticle instanceof class_3940) {
            class_3940 billboardParticle = (class_3940)createdParticle;
            billboardParticle.method_74305((float)color.red / 255.0f, (float)color.green / 255.0f, (float)color.blue / 255.0f);
            ((BillboardParticleAccessor)billboardParticle).invokeSetAlpha((float)color.alpha / 255.0f);
        }
        if (duration != null) {
            createdParticle.method_3077(duration.getTicksAsInt());
        }
        if (scaleMultiplier != null) {
            if (!scaleMultiplier.isFloat()) {
                throw new InvalidArgumentsRuntimeException("Invalid scale multiplier '" + String.valueOf(scaleMultiplier) + "' specified: must be a decimal number.");
            }
            createdParticle.method_3087(scaleMultiplier.asFloat());
        }
    }

    private static <T extends ObjectTag> T requireData(MapTag data, String key, Class<T> objectType, String particleType, ScriptEntry scriptEntry) {
        return (T)ParticleCommand.requireData(data, key, objectType, object -> true, particleType, scriptEntry);
    }

    private static <T extends ObjectTag> T requireData(MapTag data, String key, Class<T> objectType, Predicate<T> additionalCheck, String particleType, ScriptEntry scriptEntry) {
        if (data == null) {
            throw new InvalidArgumentsRuntimeException("Missing required data input for particle of type '" + particleType + "', see meta docs for more information.");
        }
        ObjectTag rawObject = data.getObject(key);
        if (rawObject == null) {
            throw new InvalidArgumentsRuntimeException("Missing required data key '" + key + "' for particle of type '" + particleType + "'.");
        }
        ObjectTag convertedObject = rawObject.asType(objectType, scriptEntry.getContext());
        if (convertedObject == null) {
            throw new InvalidArgumentsRuntimeException("Invalid " + DebugInternals.getClassNameOpti(objectType) + " specified under data key '" + key + "': " + rawObject.debuggable() + "<W>.");
        }
        if (!additionalCheck.test(convertedObject)) {
            throw new InvalidArgumentsRuntimeException("Data key '" + key + "' has a valid " + DebugInternals.getClassNameOpti(objectType) + ", but '" + convertedObject.debuggable() + "<W>' isn't valid for the key (see meta docs for more information).");
        }
        return (T)convertedObject;
    }
}

