/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.events;

import com.denizenscript.clientizen.events.EntityStartsStopsRenderingScriptEvent;
import com.denizenscript.clientizen.events.KeyPressReleaseScriptEvent;
import com.denizenscript.clientizen.events.PlayerSprintScriptEvent;
import com.denizenscript.clientizen.events.ScreenOpenCloseEvent;
import com.denizenscript.clientizen.util.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.events.ScriptEventCouldMatcher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ClientizenScriptEventRegistry {
    public static final Set<String> ENTITY_PLAINTEXT_MATCHERS = new HashSet<String>(Arrays.asList("entity", "vehicle", "fish", "projectile", "hanging", "monster", "animal", "mob", "living"));
    public static final Set<String> MATERIAL_PLAINTEXT_MATCHERS = new HashSet<String>(Arrays.asList("material", "block", "item"));
    public static final Set<String> ITEM_MATCHER_PREFIXES = new HashSet<String>(Arrays.asList("item_enchanted", "server_script"));
    public static final Set<String> ITEM_PLAINTEXT_MATCHERS = Set.of("item");

    public static void registerEvents() {
        ScriptEventCouldMatcher.knownValidatorTypes.put("entity", ClientizenScriptEventRegistry::couldMatchEntity);
        ScriptEventCouldMatcher.knownValidatorTypes.put("material", ClientizenScriptEventRegistry::couldMatchMaterial);
        ScriptEventCouldMatcher.knownValidatorTypes.put("item", ClientizenScriptEventRegistry::couldMatchItem);
        ScriptEvent.ScriptPath.notSwitches.addAll(ITEM_MATCHER_PREFIXES);
        ScriptEvent.registerScriptEvent(EntityStartsStopsRenderingScriptEvent.class);
        ScriptEvent.registerScriptEvent(KeyPressReleaseScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerSprintScriptEvent.class);
        ScriptEvent.registerScriptEvent(ScreenOpenCloseEvent.class);
    }

    public static boolean couldMatchEntity(String matcher) {
        if (ENTITY_PLAINTEXT_MATCHERS.contains(matcher)) {
            return true;
        }
        if (ScriptEvent.isAdvancedMatchable((String)matcher)) {
            ScriptEvent.MatchHelper matchHelper = ScriptEvent.createMatcher((String)matcher);
            for (class_1299 entityType : class_7923.field_41177) {
                if (!matchHelper.doesMatch(entityType.method_35050())) continue;
                return true;
            }
            ScriptEvent.addPossibleCouldMatchFailReason((String)"Matcher doesn't match any entity type", (String)matcher);
            return false;
        }
        if (class_7923.field_41177.method_10250(class_2960.method_12829((String)matcher))) {
            return true;
        }
        ScriptEvent.addPossibleCouldMatchFailReason((String)"Invalid entity type", (String)matcher);
        return false;
    }

    public static boolean couldMatchMaterial(String matcher) {
        if (MATERIAL_PLAINTEXT_MATCHERS.contains(matcher)) {
            return true;
        }
        if (ScriptEvent.isAdvancedMatchable((String)matcher)) {
            if (ClientizenScriptEventRegistry.registryContainsMatch(class_7923.field_41178, matcher)) {
                return true;
            }
            if (ClientizenScriptEventRegistry.registryContainsMatch(class_7923.field_41175, matcher)) {
                return true;
            }
            ScriptEvent.addPossibleCouldMatchFailReason((String)"Matcher doesn't match any block/item", (String)matcher);
            return false;
        }
        class_2960 id = class_2960.method_12829((String)matcher);
        if (class_7923.field_41178.method_10250(id) || class_7923.field_41175.method_10250(id)) {
            return true;
        }
        ScriptEvent.addPossibleCouldMatchFailReason((String)"Invalid block/item name", (String)matcher);
        return false;
    }

    public static boolean couldMatchItem(String matcher) {
        if (ITEM_PLAINTEXT_MATCHERS.contains(matcher)) {
            return true;
        }
        int colonIndex = matcher.indexOf(58);
        if (colonIndex != -1 && ITEM_MATCHER_PREFIXES.contains(matcher.substring(0, colonIndex))) {
            return true;
        }
        if (ScriptEvent.isAdvancedMatchable((String)matcher)) {
            if (ClientizenScriptEventRegistry.registryContainsMatch(class_7923.field_41178, matcher)) {
                return true;
            }
            ScriptEvent.addPossibleCouldMatchFailReason((String)"Matcher doesn't match any item", (String)matcher);
            return false;
        }
        if (class_7923.field_41178.method_10250(class_2960.method_12829((String)matcher))) {
            return true;
        }
        ScriptEvent.addPossibleCouldMatchFailReason((String)"Invalid item name", (String)matcher);
        return false;
    }

    private static boolean registryContainsMatch(class_2378<?> registry, String matcher) {
        ScriptEvent.MatchHelper matchHelper = ScriptEvent.createMatcher((String)matcher);
        for (class_2960 id : registry.method_10235()) {
            if (!matchHelper.doesMatch(Utilities.idToString(id))) continue;
            return true;
        }
        return false;
    }
}

