/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.scripts.containers.gui.elements;

import com.denizenscript.clientizen.scripts.containers.gui.GuiScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;

public class GridPanelElement
implements GuiScriptContainer.GuiElementParser {
    @Override
    public WWidget parse(GuiScriptContainer container, YamlConfiguration config, String pathToElement, TagContext context) {
        Integer gridSize = GuiScriptContainer.getTaggedInt(config, "grid_size", context);
        if (gridSize == null) {
            Debug.echoError((String)"Must specify a grid size.");
            return null;
        }
        WGridPanel gridPanel = new WGridPanel(gridSize.intValue());
        GuiScriptContainer.applyInsets(config, arg_0 -> ((WGridPanel)gridPanel).setInsets(arg_0), context);
        GuiScriptContainer.applyBackgroundPainter((WPanel)gridPanel, config, context);
        Integer horizontalSpacing = GuiScriptContainer.getTaggedInt(config, "horizontal_spacing", context);
        Integer verticalSpacing = GuiScriptContainer.getTaggedInt(config, "vertical_spacing", context);
        gridPanel.setGaps(horizontalSpacing != null ? horizontalSpacing : 0, verticalSpacing != null ? verticalSpacing : 0);
        YamlConfiguration content = config.getConfigurationSection("content");
        if (content == null) {
            return gridPanel;
        }
        String contentPath = GuiScriptContainer.getSubPath(pathToElement, "content");
        for (StringHolder contentIdHolder : content.contents.keySet()) {
            WWidget child = container.parseGUIWidget(content, contentIdHolder.str, contentPath, context);
            if (child == null) continue;
            gridPanel.add(child, child.getX(), child.getY(), child.getWidth(), child.getHeight());
        }
        return gridPanel;
    }
}

