/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.util;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1297;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_6903;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utilities {
    @NotNull
    public static String idToString(class_2960 identifier) {
        return identifier.method_12836().equals("minecraft") ? identifier.method_12832() : identifier.toString();
    }

    public static List<String> listRegistryKeys(class_2378<?> registry) {
        return registry.method_10235().stream().map(Utilities::idToString).toList();
    }

    @Nullable
    public static UUID uuidFromString(String uuid) {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void echoErrorByContext(TagContext context, String error) {
        if (context == null || context.showErrors()) {
            Debug.echoError((String)error);
        }
    }

    public static MapTag contactInfoToMap(ContactInformation contactInformation) {
        MapTag contact = new MapTag();
        for (Map.Entry entry : contactInformation.asMap().entrySet()) {
            contact.putObject((String)entry.getKey(), (ObjectTag)new ElementTag((String)entry.getValue(), true));
        }
        return contact;
    }

    public static MapTag personsToMap(Iterable<Person> persons) {
        MapTag personsMap = new MapTag();
        for (Person person : persons) {
            personsMap.putObject(person.getName(), (ObjectTag)Utilities.contactInfoToMap(person.getContact()));
        }
        return personsMap;
    }

    public static String camelCaseToSnake(String camelCase) {
        StringBuilder snakeCaseBuilder = new StringBuilder(camelCase.length());
        snakeCaseBuilder.append(Character.toLowerCase(camelCase.charAt(0)));
        for (int i = 1; i < camelCase.length(); ++i) {
            char character = camelCase.charAt(i);
            if (Character.isUpperCase(character)) {
                snakeCaseBuilder.append('_');
                snakeCaseBuilder.append(Character.toLowerCase(character));
                continue;
            }
            snakeCaseBuilder.append(character);
        }
        return snakeCaseBuilder.toString();
    }

    public static String orderedTextToString(class_5481 text) {
        StringBuilder converted = new StringBuilder();
        text.accept((index, style, codePoint) -> {
            converted.append(Character.toChars(codePoint));
            return true;
        });
        return converted.toString();
    }

    public static <T> class_6903<T> registryOps(DynamicOps<T> delegate) {
        return class_310.method_1551().field_1687.method_30349().method_57093(delegate);
    }

    public static boolean checkLocationWithBoundingBox(class_243 basePos, class_1297 entity, double theLeeway) {
        double zOff;
        double yOff;
        if (basePos.method_1025(entity.method_73189()) >= class_3532.method_33723((double)(theLeeway + 16.0))) {
            return false;
        }
        class_238 box = entity.method_5829();
        class_243 minPos = box.method_61125();
        class_243 maxPos = box.method_61126();
        double x = Math.max(minPos.method_10216(), Math.min(basePos.method_10216(), maxPos.method_10216()));
        double y = Math.max(minPos.method_10214(), Math.min(basePos.method_10214(), maxPos.method_10214()));
        double z = Math.max(minPos.method_10215(), Math.min(basePos.method_10215(), maxPos.method_10215()));
        double xOff = x - basePos.method_10216();
        return xOff * xOff + (yOff = y - basePos.method_10214()) * yOff + (zOff = z - basePos.method_10215()) * zOff < theLeeway * theLeeway;
    }
}

