/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.scripts.containers.gui.elements;

import com.denizenscript.clientizen.scripts.containers.gui.GuiScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WTabPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import java.util.List;
import net.minecraft.class_2561;

public class TabPanelElement
implements GuiScriptContainer.GuiElementParser {
    @Override
    public WWidget parse(GuiScriptContainer container, YamlConfiguration config, String pathToElement, TagContext context) {
        WTabPanel tabPanel = new WTabPanel();
        GuiScriptContainer.applyBackgroundPainter((WPanel)tabPanel, config, context);
        YamlConfiguration tabsConfig = config.getConfigurationSection("tabs");
        if (tabsConfig == null) {
            return tabPanel;
        }
        String tabsPath = GuiScriptContainer.getSubPath(pathToElement, "tabs");
        for (StringHolder tabIdHolder : tabsConfig.contents.keySet()) {
            Icon icon;
            List<String> tooltip;
            String tabId = tabIdHolder.str;
            YamlConfiguration tabConfig = tabsConfig.getConfigurationSection(tabId);
            if (tabConfig == null) {
                Debug.echoError((String)("Invalid tab '" + tabId + "': no options/config found."));
                continue;
            }
            WWidget content = container.parseGUIWidget(tabConfig, "content", GuiScriptContainer.getSubPath(tabsPath, tabId), context);
            if (content == null) {
                Debug.echoError((String)("Invalid tab '" + tabId + "': must have valid content."));
                continue;
            }
            WTabPanel.Tab.Builder tabBuilder = new WTabPanel.Tab.Builder(content);
            String title = GuiScriptContainer.getTaggedString(tabConfig, "title", context);
            if (title != null) {
                tabBuilder.title((class_2561)class_2561.method_43470((String)title));
            }
            if ((tooltip = GuiScriptContainer.getTaggedStringList(tabConfig, "tooltip", context)) != null) {
                tabBuilder.tooltip((class_2561[])tooltip.stream().map(class_2561::method_43470).toArray(class_2561[]::new));
            }
            if ((icon = GuiScriptContainer.parseIcon(tabConfig, "icon", context)) != null) {
                tabBuilder.icon(icon);
            }
            tabPanel.add(tabBuilder.build());
        }
        return tabPanel;
    }
}

