/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.network;

import com.denizenscript.clientizen.network.PacketIn;
import com.denizenscript.clientizen.network.PacketOut;
import com.denizenscript.clientizen.network.packets.FireEventPacketOut;
import com.denizenscript.clientizen.network.packets.ReceiveScriptsPacketIn;
import com.denizenscript.clientizen.network.packets.RunScriptPacketIn;
import com.denizenscript.clientizen.network.packets.SendConfirmationPacketOut;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class NetworkManager {
    public static void init() {
        Debug.log((String)"Initializing NetworkManager...");
        NetworkManager.registerInPacket(ReceiveScriptsPacketIn.ID, ReceiveScriptsPacketIn.CODEC);
        NetworkManager.registerInPacket(RunScriptPacketIn.ID, RunScriptPacketIn.CODEC);
        NetworkManager.registerOutPacket(FireEventPacketOut.ID, FireEventPacketOut.CODEC);
        NetworkManager.registerOutPacket(SendConfirmationPacketOut.ID, SendConfirmationPacketOut.CODEC);
    }

    public static void onConnect() {
        NetworkManager.send(new SendConfirmationPacketOut());
    }

    public static <T extends PacketIn> void registerInPacket(class_8710.class_9154<T> packetId, class_9139<class_9129, T> codec) {
        PayloadTypeRegistry.playS2C().register(packetId, codec);
        if (!ClientPlayNetworking.registerGlobalReceiver(packetId, (packet, context) -> {
            NetworkManager.debugNetwork("Received {} packet.", packet);
            packet.process();
        })) {
            Debug.echoError((String)("Tried registering in packet on channel '" + String.valueOf(packetId.comp_2242()) + "', but a packet is already registered for that channel!"));
        }
    }

    public static <T extends PacketOut> void registerOutPacket(class_8710.class_9154<T> packetId, class_9139<class_9129, T> codec) {
        PayloadTypeRegistry.playC2S().register(packetId, codec);
    }

    public static void send(PacketOut packet) {
        if (class_310.method_1551().method_1542()) {
            NetworkManager.debugNetwork("Running in single player, not sending {} packet.", packet);
            return;
        }
        NetworkManager.debugNetwork("Sending {} packet.", packet);
        ClientPlayNetworking.send((class_8710)packet);
    }

    public static void debugNetwork(String debug) {
        if (CoreConfiguration.debugExtraInfo) {
            Debug.log((String)debug);
        }
    }

    public static void debugNetwork(String debug, class_8710 packet) {
        if (CoreConfiguration.debugExtraInfo) {
            Debug.log((String)debug.replace("{}", "'<LG>" + String.valueOf(packet.method_56479().comp_2242()) + "<W>'"));
        }
    }
}

