/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.scripts.containers.gui.elements;

import com.denizenscript.clientizen.scripts.containers.gui.GuiScriptContainer;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import io.github.cottonmc.cotton.gui.widget.WSprite;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Texture;
import java.util.ArrayList;

public class SpriteElement
implements GuiScriptContainer.GuiElementParser {
    @Override
    public WWidget parse(GuiScriptContainer container, YamlConfiguration config, String pathToElement, TagContext context) {
        ColorTag tint = GuiScriptContainer.getTaggedObject(ColorTag.class, config, "tint", context);
        Texture texture = GuiScriptContainer.parseTexture(config, "texture", context);
        if (texture != null) {
            return this.applyTint(new WSprite(texture), tint);
        }
        DurationTag frameDuration = GuiScriptContainer.getTaggedObject(DurationTag.class, config, "frame_duration", context);
        if (frameDuration == null) {
            Debug.echoError((String)"Must specify a frame duration.");
            return null;
        }
        YamlConfiguration frames = config.getConfigurationSection("frames");
        if (frames == null) {
            Debug.echoError((String)"Must specify a single texture or frames for an animation.");
            return null;
        }
        ArrayList<Texture> frameTextures = new ArrayList<Texture>(frames.contents.size());
        for (StringHolder frameIdHolder : frames.contents.keySet()) {
            Texture frame = GuiScriptContainer.parseTexture(frames, frameIdHolder.low, context);
            if (frame == null) continue;
            frameTextures.add(frame);
        }
        return this.applyTint(new WSprite((int)frameDuration.getMillis(), frameTextures.toArray(new Texture[0])), tint);
    }

    private WSprite applyTint(WSprite sprite, ColorTag tint) {
        return tint != null ? sprite.setTint(tint.asARGB()) : sprite;
    }
}

