/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.util;

import com.denizenscript.clientizen.Clientizen;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class EntityAttachmentPersister {
    private static final Map<UUID, List<Pair<AttachmentType<Object>, Object>>> persistedData = new HashMap<UUID, List<Pair<AttachmentType<Object>, Object>>>();
    private static final List<AttachmentType<Object>> persistedAttachments = new ArrayList<AttachmentType<Object>>();

    public static <T> AttachmentType<T> createAttachment(String id) {
        AttachmentType attachment = AttachmentRegistry.create((class_2960)Clientizen.id(id));
        persistedAttachments.add((AttachmentType<Object>)attachment);
        return attachment;
    }

    public static void storeData(class_1297 entity) {
        ArrayList<Pair> allData = null;
        for (AttachmentType<Object> persisted : persistedAttachments) {
            Object data = entity.getAttached(persisted);
            if (data == null) continue;
            if (allData == null) {
                allData = new ArrayList<Pair>();
            }
            allData.add(Pair.of(persisted, (Object)data));
        }
        if (allData != null) {
            persistedData.put(entity.method_5667(), allData);
        }
    }

    public static void loadData(class_1297 entity) {
        List<Pair<AttachmentType<Object>, Object>> data = persistedData.remove(entity.method_5667());
        if (data == null) {
            return;
        }
        for (Pair<AttachmentType<Object>, Object> pair : data) {
            entity.setAttached((AttachmentType)pair.key(), pair.value());
        }
    }

    static {
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> EntityAttachmentPersister.loadData(entity));
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            if (class_310.method_1551().method_1562().method_48106()) {
                EntityAttachmentPersister.storeData(entity);
            }
        });
        Clientizen.SYNC_DISCONNECT.register(persistedData::clear);
    }
}

