/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.objects;

import com.denizenscript.clientizen.mixin.ClientWorldAccessor;
import com.denizenscript.clientizen.objects.ClientizenObjectRegistry;
import com.denizenscript.clientizen.objects.LocationTag;
import com.denizenscript.clientizen.util.EntityAttachmentPersister;
import com.denizenscript.clientizen.util.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1422;
import net.minecraft.class_1429;
import net.minecraft.class_1530;
import net.minecraft.class_1531;
import net.minecraft.class_1569;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3730;
import net.minecraft.class_8836;

public class EntityTag
implements ObjectTag,
Adjustable {
    private static final Set<UUID> renderedEntities = new HashSet<UUID>();
    public static final AttachmentType<Integer> GLOW_COLOR_OVERRIDE = EntityAttachmentPersister.createAttachment("glow_color_override");
    public final UUID uuid;
    public class_1297 entity;
    public final boolean isFake;
    public static final ObjectTagProcessor<EntityTag> tagProcessor = new ObjectTagProcessor();
    private String prefix = "Entity";

    public EntityTag(class_1297 entity, boolean isFake) {
        this.entity = entity;
        this.uuid = entity.method_5667();
        this.isFake = isFake;
    }

    public EntityTag(class_1297 entity) {
        this(entity, false);
    }

    public EntityTag(class_1299<?> entityType) {
        this.entity = entityType.method_5883((class_1937)class_310.method_1551().field_1687, class_3730.field_16462);
        this.uuid = null;
        this.isFake = false;
    }

    @Fetchable(value="e")
    public static EntityTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        if (ObjectFetcher.isObjectWithProperties((String)string)) {
            return (EntityTag)ObjectFetcher.getObjectFromWithProperties(ClientizenObjectRegistry.TYPE_ENTITY, (String)string, (TagContext)context);
        }
        boolean isFake = false;
        if (string.startsWith("e@fake:")) {
            string = string.substring("e@fake:".length());
            isFake = true;
        } else if (string.startsWith("e@")) {
            string = string.substring("e@".length());
        }
        int slashIndex = string.indexOf(47);
        if (slashIndex != -1) {
            String uuidString = string.substring(0, slashIndex);
            UUID uuid = Utilities.uuidFromString(uuidString);
            if (uuid == null) {
                Utilities.echoErrorByContext(context, "valueOf EntityTag returning null: UUID '" + uuidString + "' is invalid.");
                return null;
            }
            class_1297 entity = EntityTag.getEntityByUUID(uuid);
            if (entity == null) {
                return EntityTag.valueOfByType(string.substring(slashIndex + 1), context);
            }
            class_1299 entityType = class_1299.method_5898((String)string).orElse(null);
            if (entityType != null && entity.method_5864() != entityType) {
                Utilities.echoErrorByContext(context, "valueOf EntityTag returning null: UUID '" + uuidString + "' is valid, but doesn't match the provided entity type.");
                return null;
            }
            return new EntityTag(entity);
        }
        UUID uuid = Utilities.uuidFromString(string);
        if (uuid != null) {
            class_1297 entity = EntityTag.getEntityByUUID(uuid);
            if (entity == null) {
                Utilities.echoErrorByContext(context, "valueOf EntityTag returning null: UUID '" + string + "' is valid but isn't matched to any entity.");
                return null;
            }
            return new EntityTag(entity, isFake);
        }
        if (isFake) {
            Utilities.echoErrorByContext(context, "valueOf EntityTag returning null: UUID '" + string + "' is invalid.");
            return null;
        }
        return EntityTag.valueOfByType(string, context);
    }

    private static EntityTag valueOfByType(String typeString, TagContext context) {
        EntityTag entityByType = class_1299.method_5898((String)typeString).map(EntityTag::new).orElse(null);
        if (entityByType == null) {
            Utilities.echoErrorByContext(context, "valueOf EntityTag returning null: invalid entity type '" + typeString + "'.");
            return null;
        }
        return entityByType;
    }

    public static class_1297 getEntityByUUID(UUID uuid) {
        return (class_1297)((ClientWorldAccessor)class_310.method_1551().field_1687).invokeGetEntityLookup().method_31808(uuid);
    }

    public static boolean matches(String string) {
        if (string.startsWith("e@")) {
            return true;
        }
        return EntityTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public class_1297 getEntity() {
        class_1297 found;
        if ((this.entity == null || this.entity.method_31481()) && (found = EntityTag.getEntityByUUID(this.uuid)) != null) {
            this.entity = found;
        }
        return this.entity;
    }

    public String getTypeName() {
        return this.getEntity().method_5864().method_35050();
    }

    public float getSpigotYaw() {
        class_1297 entity = this.getEntity();
        if (entity instanceof class_1309 && !(entity instanceof class_1531)) {
            return entity.method_5791();
        }
        return entity.method_36454();
    }

    public boolean isSpawned() {
        return this.uuid != null && this.getEntity() != null && this.entity.method_5805();
    }

    public boolean is(class_1299<?> type) {
        return this.getEntity().method_5864() == type;
    }

    public static Set<UUID> getRenderedEntities() {
        return renderedEntities;
    }

    public static void register() {
        PropertyParser.registerPropertyTagHandlers(EntityTag.class, tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "entity_type", (attribute, object) -> new ElementTag(object.getTypeName(), true), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "location", (attribute, object) -> new LocationTag((class_2374)object.getEntity().method_73189(), object.getSpigotYaw(), object.getEntity().method_36455()), new String[0]);
        tagProcessor.registerTag(LocationTag.class, "eye_location", (attribute, object) -> new LocationTag((class_2374)object.getEntity().method_33571(), object.getSpigotYaw(), object.getEntity().method_36455()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_rendering", (attribute, object) -> new ElementTag(renderedEntities.contains(object.getEntity().method_5667())), new String[0]);
        tagProcessor.registerTag(ColorTag.class, "glow_color_override", (attribute, object) -> {
            Integer glowColor = (Integer)object.getEntity().getAttached(GLOW_COLOR_OVERRIDE);
            return glowColor != null ? ColorTag.fromRGB((int)glowColor) : null;
        }, new String[0]);
        tagProcessor.registerMechanism("glow_color_override", false, (object, mechanism) -> {
            if (!mechanism.hasValue()) {
                object.getEntity().removeAttached(GLOW_COLOR_OVERRIDE);
            } else if (mechanism.requireObject(ColorTag.class)) {
                object.getEntity().setAttached(GLOW_COLOR_OVERRIDE, (Object)((ColorTag)mechanism.valueAsType(ColorTag.class)).asRGB());
            }
        }, new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism((ObjectTag)this, mechanism);
    }

    public void applyProperty(Mechanism mechanism) {
        if (this.isUnique()) {
            mechanism.echoError("Cannot apply properties to already-spawned entities.");
            return;
        }
        this.adjust(mechanism);
    }

    public String identify() {
        if (this.uuid != null) {
            return this.isFake ? "e@fake:" + String.valueOf(this.uuid) : "e@" + String.valueOf(this.uuid) + "/" + this.getTypeName();
        }
        return "e@" + this.getTypeName() + PropertyParser.getPropertiesString((ObjectTag)this);
    }

    public String identifySimple() {
        return this.isFake ? "e@fake:" + String.valueOf(this.uuid) : "e@" + String.valueOf(this.uuid != null ? this.uuid : this.getTypeName());
    }

    public String debuggable() {
        if (this.uuid != null) {
            Object debuggable = "<LG>e@";
            if (this.isFake) {
                debuggable = (String)debuggable + "FAKE:";
            }
            debuggable = (String)debuggable + "<Y>" + String.valueOf(this.uuid) + "<GR>(" + this.getTypeName();
            class_2561 displayName = this.entity.method_5797();
            if (displayName != null) {
                debuggable = (String)debuggable + "<LG>/<GR>" + displayName.getString();
            }
            return (String)debuggable + ")";
        }
        return "<LG>e@<Y>" + this.getTypeName() + PropertyParser.getPropertiesDebuggable((ObjectTag)this);
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        return this.uuid != null;
    }

    public boolean advancedMatches(String matcher, TagContext context) {
        return ScriptEvent.createMatcher((String)matcher).doesMatch(this.getTypeName(), text -> switch (text) {
            case "entity" -> true;
            case "vehicle" -> this.getEntity() instanceof class_8836;
            case "fish" -> this.getEntity() instanceof class_1422;
            case "projectile" -> this.getEntity() instanceof class_1676;
            case "hanging" -> this.getEntity() instanceof class_1530;
            case "monster" -> this.getEntity() instanceof class_1569;
            case "animal" -> this.getEntity() instanceof class_1429;
            case "mob" -> this.getEntity() instanceof class_1308;
            case "living" -> this.getEntity() instanceof class_1309;
            default -> false;
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

