/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.objects;

import com.denizenscript.clientizen.objects.ClientizenObjectRegistry;
import com.denizenscript.clientizen.objects.MaterialTag;
import com.denizenscript.clientizen.util.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9304;

public class ItemTag
implements ObjectTag,
Adjustable {
    final class_1799 itemStack;
    final class_2960 identifier;
    public String script;
    public static final ObjectTagProcessor<ItemTag> tagProcessor = new ObjectTagProcessor();
    String prefix = "Item";

    public ItemTag(class_1799 itemStack) {
        this.itemStack = itemStack;
        this.identifier = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
    }

    public ItemTag(class_1935 convertible) {
        this(convertible.method_8389().method_7854());
    }

    public ItemTag(MaterialTag material) {
        this((class_1935)(material.item != null ? material.item : material.state.method_26204()));
    }

    @Fetchable(value="i")
    public static ItemTag valueOf(String string, TagContext context) {
        if (string.startsWith("i@")) {
            string = string.substring("i@".length());
        }
        if (ObjectFetcher.isObjectWithProperties((String)string)) {
            return (ItemTag)ObjectFetcher.getObjectFromWithProperties(ClientizenObjectRegistry.TYPE_ITEM, (String)string, (TagContext)context);
        }
        MaterialTag material = MaterialTag.valueOf(string, context);
        if (material == null) {
            if (context == null || context.showErrors()) {
                Debug.echoError((String)("valueOf ItemTag returning null: invalid item type '" + string + "' specified."));
            }
            return null;
        }
        return new ItemTag(material);
    }

    public static boolean matches(String string) {
        if (string.startsWith("i@")) {
            return true;
        }
        class_2960 identifier = class_2960.method_12829((String)string);
        return identifier != null && (class_7923.field_41178.method_10250(identifier) || class_7923.field_41175.method_10250(identifier));
    }

    public static void register() {
        PropertyParser.registerPropertyTagHandlers(ItemTag.class, tagProcessor);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism((ObjectTag)this, mechanism);
    }

    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    public class_1799 getStack() {
        return this.itemStack;
    }

    public String getName() {
        return Utilities.idToString(this.identifier);
    }

    public String identify() {
        return "i@" + this.getName() + PropertyParser.getPropertiesString((ObjectTag)this);
    }

    public String identifySimple() {
        return "i@" + this.getName();
    }

    public String debuggable() {
        return "<LG>i@<Y>" + this.getName() + PropertyParser.getPropertiesDebuggable((ObjectTag)this);
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        return false;
    }

    public boolean advancedMatches(String matcher, TagContext context) {
        return ScriptEvent.createMatcher((String)matcher).doesMatch(this.getName(), text -> {
            if (text.equals("item")) {
                return true;
            }
            int colonIndex = text.indexOf(58);
            if (colonIndex != -1) {
                String prefix = text.substring(0, colonIndex);
                String value = text.substring(colonIndex + 1);
                switch (prefix) {
                    case "item_enchanted": {
                        class_9304 enchantments = this.getStack().method_58657();
                        if (enchantments.method_57543()) {
                            return false;
                        }
                        ScriptEvent.MatchHelper matchHelper = ScriptEvent.createMatcher((String)value);
                        for (class_6880 enchantment : enchantments.method_57534()) {
                            class_5321 key = enchantment.method_40230().orElse(null);
                            if (key == null || !matchHelper.doesMatch(Utilities.idToString(key.method_29177()))) continue;
                            return true;
                        }
                        return false;
                    }
                    case "server_script": {
                        return this.script != null && ScriptEvent.runGenericCheck((String)value, (String)this.script);
                    }
                }
            }
            return false;
        });
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

