/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.events;

import com.denizenscript.clientizen.util.ScreenNameMapping;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_437;

public class ScreenOpenCloseEvent
extends ScriptEvent {
    public static ScreenOpenCloseEvent instance;
    public String type;
    public boolean opened;
    public String previousType;

    public ScreenOpenCloseEvent() {
        this.registerCouldMatcher("screen opened|closed");
        this.registerSwitches(new String[]{"type", "from"});
        instance = this;
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!ScreenOpenCloseEvent.runGenericSwitchCheck((ScriptEvent.ScriptPath)path, (String)"type", (String)this.type)) {
            return false;
        }
        if (!ScreenOpenCloseEvent.runGenericSwitchCheck((ScriptEvent.ScriptPath)path, (String)"from", (String)this.previousType)) {
            return false;
        }
        if (this.opened != path.eventArgLowerAt(1).equals("opened")) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "screen_type" -> new ElementTag(this.type, true);
            case "previous_screen_type" -> {
                if (this.previousType != null) {
                    yield new ElementTag(this.previousType, true);
                }
                yield null;
            }
            default -> super.getContext(name);
        };
    }

    public void handleScreenChange(class_437 screen, class_437 previousScreen, boolean open) {
        if (!this.eventData.isEnabled) {
            return;
        }
        this.type = ScreenNameMapping.getScreenName(screen);
        this.previousType = previousScreen != null ? ScreenNameMapping.getScreenName(previousScreen) : null;
        this.opened = open;
        this.fire();
    }

    static {
        ScreenEvents.AFTER_INIT.register((client, openedScreen, scaledWidth, scaledHeight) -> ScreenEvents.remove((class_437)openedScreen).register(closedScreen -> instance.handleScreenChange(closedScreen, null, false)));
    }
}

