/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.scripts.containers.gui.elements;

import com.denizenscript.clientizen.scripts.containers.gui.GuiScriptContainer;
import com.denizenscript.clientizen.util.impl.ClientizenScriptEntryData;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.github.cottonmc.cotton.gui.widget.WAbstractSlider;
import io.github.cottonmc.cotton.gui.widget.WSlider;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.commons.lang3.function.TriFunction;

public class SliderElement
implements GuiScriptContainer.GuiElementParser {
    @Override
    public WWidget parse(GuiScriptContainer container, YamlConfiguration config, String pathToElement, TagContext context) {
        return SliderElement.parseSlider(WSlider::new, container, config, pathToElement, context);
    }

    public static <T extends WAbstractSlider> T parseSlider(TriFunction<Integer, Integer, Axis, T> constructor, GuiScriptContainer container, YamlConfiguration config, String pathToElement, TagContext context) {
        Integer value;
        Integer min = GuiScriptContainer.getTaggedInt(config, "min", 0, context);
        if (min == null) {
            return null;
        }
        Integer max = GuiScriptContainer.getTaggedInt(config, "max", context);
        if (max == null) {
            Debug.echoError((String)"Must specify a max value");
            return null;
        }
        Axis axis = GuiScriptContainer.getTaggedEnum(Axis.class, config, "axis", context);
        if (axis == null) {
            Debug.echoError((String)"Must specify an axis.");
            return null;
        }
        WAbstractSlider slider = (WAbstractSlider)constructor.apply((Object)min, (Object)max, (Object)axis);
        WAbstractSlider.Direction direction = GuiScriptContainer.getTaggedEnum(WAbstractSlider.Direction.class, config, "direction", context);
        if (direction != null) {
            if (direction.getAxis() != axis) {
                Debug.echoError((String)("Invalid direction '" + String.valueOf(direction) + "': can't be used with axis '" + String.valueOf(axis) + "'."));
                return null;
            }
            slider.setDirection(direction);
        }
        if ((value = GuiScriptContainer.getTaggedInt(config, "value", context)) != null) {
            slider.setValue(value.intValue());
        }
        SliderElement.addListener(arg_0 -> ((WAbstractSlider)slider).setValueChangeListener(arg_0), container, pathToElement, "on_change", "_change");
        SliderElement.addListener(arg_0 -> ((WAbstractSlider)slider).setDraggingFinishedListener(arg_0), container, pathToElement, "on_set", "_set");
        return (T)slider;
    }

    private static void addListener(Consumer<IntConsumer> setter, GuiScriptContainer container, String pathToElement, String scriptPath, String queueSuffix) {
        List toRun = container.getEntries(new ClientizenScriptEntryData(), GuiScriptContainer.getSubPath(pathToElement, scriptPath));
        if (toRun == null) {
            return;
        }
        String queueName = GuiScriptContainer.getWidgetId(pathToElement) + queueSuffix;
        ContextSource.SimpleMap contextSource = new ContextSource.SimpleMap();
        setter.accept(newValue -> {
            contextSource.contexts = Map.of("new_value", new ElementTag(newValue));
            ScriptUtilities.createAndStartQueueArbitrary((String)queueName, (List)toRun, null, (ContextSource)contextSource, null);
        });
    }
}

