/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.scripts.containers.gui.elements;

import com.denizenscript.clientizen.scripts.containers.gui.GuiScriptContainer;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.github.cottonmc.cotton.gui.widget.WDynamicLabel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;

public class DynamicLabelElement
implements GuiScriptContainer.GuiElementParser {
    @Override
    public WWidget parse(GuiScriptContainer container, YamlConfiguration config, String pathToElement, TagContext context) {
        ColorTag color;
        VerticalAlignment verticalAlignment;
        String text = config.getString("text");
        if (text == null) {
            Debug.echoError((String)"Must have text.");
            return null;
        }
        ParseableTag parseableTag = TagManager.parseTextToTag((String)text, (TagContext)context);
        String errorContext = "while parsing text for dynamic label '<A>" + GuiScriptContainer.getDebugPath(pathToElement) + "<LR>'";
        WDynamicLabel dynamicLabel = new WDynamicLabel(() -> {
            Debug.pushErrorContext((Object)errorContext);
            try {
                String string = parseableTag.parse(context).toString();
                return string;
            }
            finally {
                Debug.popErrorContext();
            }
        });
        HorizontalAlignment horizontalAlignment = GuiScriptContainer.getTaggedEnum(HorizontalAlignment.class, config, "horizontal_alignment", context);
        if (horizontalAlignment != null) {
            dynamicLabel.setHorizontalAlignment(horizontalAlignment);
        }
        if ((verticalAlignment = GuiScriptContainer.getTaggedEnum(VerticalAlignment.class, config, "vertical_alignment", context)) != null) {
            dynamicLabel.setVerticalAlignment(verticalAlignment);
        }
        if ((color = GuiScriptContainer.getTaggedObject(ColorTag.class, config, "color", context)) != null) {
            dynamicLabel.setColor(color.asARGB(), -4408132);
        }
        return dynamicLabel;
    }
}

