/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.scripts.containers.gui.elements;

import com.denizenscript.clientizen.scripts.containers.gui.GuiScriptContainer;
import com.denizenscript.clientizen.util.impl.ClientizenScriptEntryData;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;

public class TextFieldElement
implements GuiScriptContainer.GuiElementParser {
    @Override
    public WWidget parse(GuiScriptContainer container, YamlConfiguration config, String pathToElement, TagContext context) {
        List onChange;
        String inputChecker;
        ColorTag suggestionColor;
        ColorTag enabledColor;
        ColorTag disabledColor;
        Integer maxLength;
        Boolean editable;
        String text;
        WTextField textField = new WTextField();
        String suggestion = GuiScriptContainer.getTaggedString(config, "suggestion", context);
        if (suggestion != null) {
            textField.setSuggestion((class_2561)class_2561.method_43470((String)suggestion));
        }
        if ((text = GuiScriptContainer.getTaggedString(config, "text", context)) != null) {
            textField.setText(text);
        }
        if ((editable = GuiScriptContainer.getTaggedBoolean(config, "editable", context)) != null) {
            textField.setEditable(editable.booleanValue());
        }
        if ((maxLength = GuiScriptContainer.getTaggedInt(config, "max_length", context)) != null) {
            textField.setMaxLength(maxLength.intValue());
        }
        if ((disabledColor = GuiScriptContainer.getTaggedObject(ColorTag.class, config, "disabled_color", context)) != null) {
            textField.setDisabledColor(disabledColor.asARGB());
        }
        if ((enabledColor = GuiScriptContainer.getTaggedObject(ColorTag.class, config, "enabled_color", context)) != null) {
            textField.setEnabledColor(enabledColor.asARGB());
        }
        if ((suggestionColor = GuiScriptContainer.getTaggedObject(ColorTag.class, config, "suggestion_color", context)) != null) {
            textField.setSuggestionColor(suggestionColor.asARGB());
        }
        if ((inputChecker = config.getString("input_checker")) != null) {
            ParseableTag checkerTag = TagManager.parseTextToTag((String)inputChecker, (TagContext)context);
            String errorContext = "in input checker for text field '<A>" + GuiScriptContainer.getDebugPath(pathToElement) + "<LR>'";
            TagContext checkingContext = context.clone();
            ContextSource.SimpleMap contextSource = new ContextSource.SimpleMap();
            checkingContext.contextSource = contextSource;
            textField.setTextPredicate(newText -> {
                contextSource.contexts = Map.of("new_text", new ElementTag(newText, true));
                Debug.pushErrorContext((Object)errorContext);
                try {
                    ElementTag parsedCheck = checkerTag.parse(checkingContext).asElement();
                    if (!parsedCheck.isBoolean()) {
                        Debug.echoError((String)("Invalid boolean value '" + String.valueOf(parsedCheck) + "' returned: must be either 'true' or 'false'."));
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = parsedCheck.asBoolean();
                    return bl;
                }
                finally {
                    Debug.popErrorContext();
                }
            });
        }
        if ((onChange = container.getEntries(new ClientizenScriptEntryData(), GuiScriptContainer.getSubPath(pathToElement, "on_change"))) != null) {
            ContextSource.SimpleMap contextSource = new ContextSource.SimpleMap();
            String queueName = GuiScriptContainer.getWidgetId(pathToElement) + "_changed";
            textField.setChangedListener(newText -> {
                contextSource.contexts = Map.of("new_text", new ElementTag(newText, true));
                ScriptUtilities.createAndStartQueueArbitrary((String)queueName, (List)onChange, null, (ContextSource)contextSource, null);
            });
        }
        return textField;
    }
}

