/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ImageTag;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.core.ImageCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import java.awt.Graphics2D;

public class DrawCommand
extends AbstractCommand {
    public DrawCommand() {
        this.setName("draw");
        this.setSyntax("draw [id:<id>] [pixel/rectangle/oval/image:<image>] (width:<width>) (height:<height>) (filled) [x:<x>] [y:<y>] (color:<color>)");
        this.setRequiredArguments(4, 8);
        this.autoCompile();
    }

    public static void autoExecute(@ArgName(value="id") @ArgPrefixed String id, @ArgName(value="draw") @ArgDefaultNull Drawable drawable, @ArgName(value="image") @ArgPrefixed @ArgDefaultNull ImageTag toDraw, @ArgName(value="x") @ArgPrefixed int x, @ArgName(value="y") @ArgPrefixed int y, @ArgName(value="width") @ArgPrefixed @ArgDefaultText(value="-1") int width, @ArgName(value="height") @ArgPrefixed @ArgDefaultText(value="-1") int height, @ArgName(value="color") @ArgPrefixed @ArgDefaultNull ColorTag color, @ArgName(value="filled") boolean filled) {
        ImageTag image = ImageCommand.getImageFrom(id);
        if (toDraw != null) {
            if (width == -1) {
                width = toDraw.image.getWidth();
            }
            if (height == -1) {
                height = toDraw.image.getHeight();
            }
            Graphics2D graphics = image.image.createGraphics();
            graphics.drawImage(toDraw.image, x, y, width, height, null);
            graphics.dispose();
            return;
        }
        if (color == null) {
            throw new InvalidArgumentsRuntimeException("Must specify a color to draw in.");
        }
        if (drawable == Drawable.PIXEL) {
            image.image.setRGB(x, y, color.asARGB());
            return;
        }
        if (width == -1 || height == -1) {
            throw new InvalidArgumentsRuntimeException("Must specify a width and height.");
        }
        if (drawable == null) {
            throw new InvalidArgumentsRuntimeException("Must specify what to draw.");
        }
        Graphics2D graphics = image.image.createGraphics();
        graphics.setColor(color.getAWTColor());
        switch (drawable.ordinal()) {
            case 1: {
                if (filled) {
                    graphics.fillRect(x, y, width, height);
                    break;
                }
                graphics.drawRect(x, y, width - 1, height - 1);
                break;
            }
            case 2: {
                if (filled) {
                    graphics.fillOval(x, y, width, height);
                    break;
                }
                graphics.drawOval(x, y, width - 1, height - 1);
            }
        }
        graphics.dispose();
    }

    public static enum Drawable {
        PIXEL,
        RECTANGLE,
        OVAL;

    }
}

