/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BrewingStartEvent;

public class BrewingStartsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public BrewingStartEvent event;

    public BrewingStartsScriptEvent() {
        this.registerCouldMatcher("brewing starts");
        this.registerDetermination("brew_time", DurationTag.class, (evt, context, time) -> evt.event.setTotalBrewTime(time.getTicksAsInt()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getBlock().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "item" -> new ItemTag(this.event.getSource());
            case "location" -> new LocationTag(this.event.getBlock().getLocation());
            case "brew_time" -> new DurationTag((long)this.event.getTotalBrewTime());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBrewingStart(BrewingStartEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

