/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;

public class EntityHasStung
implements Property {
    public static final String[] handledTags = new String[]{"has_stung"};
    public static final String[] handledMechs = new String[]{"has_stung"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        Entity bukkitEntity = ((EntityTag)entity).getBukkitEntity();
        return bukkitEntity instanceof Bee;
    }

    public static EntityHasStung getFrom(ObjectTag entity) {
        if (!EntityHasStung.describes(entity)) {
            return null;
        }
        return new EntityHasStung((EntityTag)entity);
    }

    public EntityHasStung(EntityTag entity) {
        this.entity = entity;
    }

    public Bee getBee() {
        return (Bee)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        return this.getBee().hasStung() ? "true" : "false";
    }

    @Override
    public String getPropertyId() {
        return "has_stung";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_stung")) {
            return new ElementTag(this.getBee().hasStung()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("has_stung") && mechanism.requireBoolean()) {
            this.getBee().setHasStung(mechanism.getValue().asBoolean());
        }
    }
}

