/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class WardenChangesAngerLevelScriptEvent
extends BukkitScriptEvent
implements Listener {
    public WardenAngerChangeEvent event;

    public WardenChangesAngerLevelScriptEvent() {
        this.registerCouldMatcher("warden changes anger level");
        this.registerOptionalDetermination("anger", ElementTag.class, (evt, context, anger) -> {
            if (anger.isInt()) {
                evt.event.setNewAnger(anger.asInt());
                return true;
            }
            return false;
        });
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getEntity().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> new EntityTag((Entity)this.event.getEntity());
            case "new_anger" -> new ElementTag(this.event.getNewAnger());
            case "old_anger" -> new ElementTag(this.event.getOldAnger());
            case "target" -> {
                if (this.event.getTarget() != null) {
                    yield new EntityTag(this.event.getTarget()).getDenizenObject();
                }
                yield null;
            }
            default -> super.getContext(name);
        };
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event.getTarget());
    }

    @EventHandler
    public void onWardenAngerChange(WardenAngerChangeEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

