/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Pose;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPoseChangeEvent;

public class EntityChangesPoseScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public Pose oldPose;
    public EntityPoseChangeEvent event;

    public EntityChangesPoseScriptEvent() {
        this.registerCouldMatcher("<entity> changes pose");
        this.registerSwitches("old", "new");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!EntityChangesPoseScriptEvent.runGenericSwitchCheck(path, "old", this.oldPose.name())) {
            return false;
        }
        if (!EntityChangesPoseScriptEvent.runGenericSwitchCheck(path, "new", this.event.getPose().name())) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity;
            }
            case "old_pose": {
                return new ElementTag((Enum<?>)this.oldPose);
            }
            case "new_pose": {
                return new ElementTag((Enum<?>)this.event.getPose());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPoseChange(EntityPoseChangeEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.oldPose = this.entity.getBukkitEntity().getPose();
        this.event = event;
        this.fire((Event)event);
    }
}

