/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.EnumSet;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class TablistCommand
extends AbstractCommand {
    public TablistCommand() {
        this.setName("tablist");
        this.setSyntax("tablist [add/remove/update] (name:<name>) (display:<display>) (uuid:<uuid>) (skin_blob:<blob>) (latency:<#>) (gamemode:creative/survival/adventure/spectator) (listed:true/false)");
        this.setRequiredArguments(2, 8);
        this.isProcedural = false;
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("gamemode:", (Enum<?>[])GameMode.values());
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="mode") Mode mode, @ArgDefaultNull @ArgPrefixed @ArgName(value="name") String name, @ArgDefaultNull @ArgPrefixed @ArgName(value="display") String display, @ArgDefaultNull @ArgPrefixed @ArgName(value="uuid") String uuid, @ArgDefaultNull @ArgPrefixed @ArgName(value="skin_blob") String skinBlob, @ArgDefaultNull @ArgPrefixed @ArgName(value="latency") ElementTag latency, @ArgDefaultNull @ArgPrefixed @ArgName(value="gamemode") GameMode gamemode, @ArgDefaultNull @ArgPrefixed @ArgName(value="listed") ElementTag listed) {
        UUID id;
        if (!Utilities.entryHasPlayer(scriptEntry)) {
            Debug.echoError("Must have a linked player!");
            return;
        }
        Player player = Utilities.getEntryPlayer(scriptEntry).getPlayerEntity();
        if (listed != null && !listed.isBoolean()) {
            Debug.echoError("Invalid input '" + String.valueOf(listed) + "' to 'listed': must be a boolean");
            return;
        }
        if (uuid != null) {
            try {
                id = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException ex) {
                Debug.echoError("Invalid UUID '" + uuid + "'");
                return;
            }
        } else {
            id = UUID.randomUUID();
        }
        String texture = null;
        String signature = null;
        if (skinBlob != null) {
            int semicolon = skinBlob.indexOf(59);
            if (semicolon == -1) {
                Debug.echoError("Invalid skinblob '" + skinBlob + "'");
                return;
            }
            texture = skinBlob.substring(0, semicolon);
            signature = skinBlob.substring(semicolon + 1);
        }
        if (latency != null && !latency.isInt()) {
            Debug.echoError("Invalid latency, not a number '" + String.valueOf(latency) + "'");
            return;
        }
        int latencyNum = latency == null ? 0 : latency.asInt();
        switch (mode.ordinal()) {
            case 0: {
                boolean listedBool;
                if (name == null) {
                    throw new InvalidArgumentsRuntimeException("'name' wasn't specified but is required for 'add'");
                }
                if (!(display != null && display.length() <= 0 || CoreConfiguration.allowRestrictedActions)) {
                    Debug.echoError("Cannot use 'tablist add' to add a non-empty display-named entry: 'Allow restricted actions' is disabled in Denizen config.yml.");
                    return;
                }
                if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_18)) {
                    NMSHandler.playerHelper.sendPlayerInfoAddPacket(player, EnumSet.of(PlayerHelper.ProfileEditMode.ADD), name, display, id, texture, signature, latencyNum, gamemode == null ? GameMode.CREATIVE : gamemode, false);
                    return;
                }
                EnumSet<PlayerHelper.ProfileEditMode> editModes = EnumSet.of(PlayerHelper.ProfileEditMode.ADD);
                boolean bl = listedBool = listed == null || listed.asBoolean();
                if (listedBool) {
                    editModes.add(PlayerHelper.ProfileEditMode.UPDATE_LISTED);
                }
                if (display != null) {
                    editModes.add(PlayerHelper.ProfileEditMode.UPDATE_DISPLAY);
                }
                if (latency != null) {
                    editModes.add(PlayerHelper.ProfileEditMode.UPDATE_LATENCY);
                }
                if (gamemode != null) {
                    editModes.add(PlayerHelper.ProfileEditMode.UPDATE_GAME_MODE);
                }
                NMSHandler.playerHelper.sendPlayerInfoAddPacket(player, editModes, name, display, id, texture, signature, latencyNum, gamemode, listedBool);
                break;
            }
            case 1: {
                if (uuid == null) {
                    throw new InvalidArgumentsRuntimeException("'uuid' wasn't specified but is required for 'remove'");
                }
                NMSHandler.playerHelper.sendPlayerInfoRemovePacket(player, id);
                break;
            }
            case 2: {
                if (uuid == null) {
                    throw new InvalidArgumentsRuntimeException("'uuid' wasn't specified but is required for 'update'");
                }
                if (!(display != null && display.length() <= 0 || CoreConfiguration.allowRestrictedActions)) {
                    Debug.echoError("Cannot use 'tablist update' to create a non-empty named entry: 'Allow restricted actions' is disabled in Denizen config.yml.");
                    return;
                }
                if (NMSHandler.getVersion().isAtMost(NMSVersion.v1_18)) {
                    if (display != null) {
                        NMSHandler.playerHelper.sendPlayerInfoAddPacket(player, EnumSet.of(PlayerHelper.ProfileEditMode.UPDATE_DISPLAY), name, display, id, texture, signature, latencyNum, gamemode, false);
                    }
                    if (latency != null) {
                        NMSHandler.playerHelper.sendPlayerInfoAddPacket(player, EnumSet.of(PlayerHelper.ProfileEditMode.UPDATE_LATENCY), name, display, id, texture, signature, latencyNum, gamemode, false);
                    }
                    return;
                }
                EnumSet<PlayerHelper.ProfileEditMode> editModes = EnumSet.noneOf(PlayerHelper.ProfileEditMode.class);
                if (display != null) {
                    editModes.add(PlayerHelper.ProfileEditMode.UPDATE_DISPLAY);
                }
                if (latency != null) {
                    editModes.add(PlayerHelper.ProfileEditMode.UPDATE_LATENCY);
                }
                if (gamemode != null) {
                    editModes.add(PlayerHelper.ProfileEditMode.UPDATE_GAME_MODE);
                }
                if (listed != null) {
                    editModes.add(PlayerHelper.ProfileEditMode.UPDATE_LISTED);
                }
                NMSHandler.playerHelper.sendPlayerInfoAddPacket(player, editModes, name, display, id, texture, signature, latencyNum, gamemode, listed == null || listed.asBoolean());
            }
        }
    }

    public static enum Mode {
        ADD,
        REMOVE,
        UPDATE;

    }
}

