/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.paper.PaperModule;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PlayerNameEntityEvent;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerNameEntityScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerNameEntityEvent event;
    public EntityTag entity;
    public ElementTag oldName;

    public PlayerNameEntityScriptEvent() {
        this.registerCouldMatcher("player names <entity>");
        this.registerOptionalDetermination("persistent", ElementTag.class, (evt, context, determination) -> {
            if (determination.isBoolean()) {
                evt.event.setPersistent(determination.asBoolean());
                return true;
            }
            return false;
        });
        this.registerDetermination("name", ElementTag.class, (evt, context, determination) -> evt.event.setName(PaperModule.parseFormattedText(determination.toString(), ChatColor.WHITE)));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        if (!path.tryArgObject(2, this.entity)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity.getDenizenObject();
            case "name" -> new ElementTag(PaperModule.stringifyComponent(this.event.getName()), true);
            case "old_name" -> this.oldName;
            case "persistent" -> new ElementTag(this.event.isPersistent());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void playerNamesEntity(PlayerNameEntityEvent event) {
        this.event = event;
        this.entity = new EntityTag((Entity)event.getEntity());
        String name = PaperAPITools.instance.getCustomName(this.entity.getBukkitEntity());
        this.oldName = name == null ? null : new ElementTag(name, true);
        this.fire((Event)event);
    }
}

