/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerQuitsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerQuitEvent event;
    public LocationTag location;

    public PlayerQuitsScriptEvent() {
        this.registerCouldMatcher("player quits|quit");
        this.registerTextDetermination("none", evt -> this.event.setQuitMessage(null));
        this.registerDetermination(null, ElementTag.class, (evt, context, determination) -> this.event.setQuitMessage(determination.asString()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "message" -> new ElementTag(this.event.getQuitMessage());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerQuits(PlayerQuitEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        if (!event.getPlayer().isOnline()) {
            return;
        }
        this.location = new LocationTag(event.getPlayer().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

