/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCookEvent;

public class BlockCooksSmeltsItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ItemTag source_item;
    public ItemTag result_item;
    public LocationTag location;
    public BlockCookEvent event;

    public BlockCooksSmeltsItemScriptEvent() {
        this.registerCouldMatcher("<block> cooks|smelts <item> (into <item>)");
        this.registerDetermination(null, ItemTag.class, (evt, context, result) -> this.event.setResult(result.getItemStack()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.location)) {
            return false;
        }
        if (!path.tryArgObject(2, this.source_item)) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("into") && !path.tryArgObject(4, this.result_item)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "source_item" -> this.source_item;
            case "result_item" -> new ItemTag(this.event.getResult());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBlockCooks(BlockCookEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.source_item = new ItemTag(event.getSource());
        this.result_item = new ItemTag(event.getResult());
        this.event = event;
        this.fire((Event)event);
    }
}

