/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;

public class ResourcePackCommand
extends AbstractCommand {
    public ResourcePackCommand() {
        this.setName("resourcepack");
        this.setSyntax("resourcepack [url:<url>] [hash:<hash>] (forced) (prompt:<text>) (targets:<player>|...)");
        this.setRequiredArguments(2, 5);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="url") @ArgPrefixed String url, @ArgName(value="hash") @ArgPrefixed String hash, @ArgName(value="prompt") @ArgPrefixed @ArgDefaultNull String prompt, @ArgName(value="targets") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> targets, @ArgName(value="forced") boolean forced) {
        if (targets == null) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsRuntimeException("Must specify an online player!");
            }
            targets = Collections.singletonList(Utilities.getEntryPlayer(scriptEntry));
        }
        if (hash.length() != 40) {
            Debug.echoError("Invalid resource_pack hash. Should be 40 characters of hexadecimal data.");
            return;
        }
        for (PlayerTag player : targets) {
            if (!player.isOnline()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Player is offline, can't send resource pack to them. Skipping.");
                continue;
            }
            PaperAPITools.instance.sendResourcePack(player.getPlayerEntity(), url, hash, forced, prompt);
        }
    }
}

