/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.math;

import com.denizenscript.denizencore.utilities.math.Vector3;

public class Quaternion {
    public double x;
    public double y;
    public double z;
    public double w;

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public static Quaternion identity() {
        return new Quaternion(0.0, 0.0, 0.0, 1.0);
    }

    public static Quaternion fromAxisAngle(Vector3 axis, double angle) {
        double s = Math.sin(angle * 0.5);
        return new Quaternion(axis.x * s, axis.y * s, axis.z * s, Math.cos(angle * 0.5));
    }

    public static Quaternion getQuaternionBetween(Vector3 v1, Vector3 v2) {
        double dot = v1.dot(v2);
        if (dot < (double)-0.9999f) {
            double absX = Math.abs(v1.x);
            double absY = Math.abs(v1.y);
            double absZ = Math.abs(v1.z);
            if (absX < absY && absX < absZ) {
                return new Quaternion(0.0, -v1.z, v1.y, 0.0).normalized();
            }
            if (absY < absZ) {
                return new Quaternion(-v1.z, 0.0, v1.x, 0.0).normalized();
            }
            return new Quaternion(-v1.y, v1.x, 0.0, 0.0).normalized();
        }
        Vector3 axis = v1.crossProduct(v2);
        return new Quaternion(axis.x, axis.y, axis.z, dot + 1.0).normalized();
    }

    public Quaternion normalized() {
        double len_inv = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        return new Quaternion(this.x * len_inv, this.y * len_inv, this.z * len_inv, this.w * len_inv);
    }

    public Vector3 transform(Vector3 v) {
        double x2 = this.x * 2.0;
        double y2 = this.y * 2.0;
        double z2 = this.z * 2.0;
        double xx2 = this.x * x2;
        double xy2 = this.x * y2;
        double xz2 = this.x * z2;
        double yy2 = this.y * y2;
        double yz2 = this.y * z2;
        double zz2 = this.z * z2;
        double wx2 = this.w * x2;
        double wy2 = this.w * y2;
        double wz2 = this.w * z2;
        return new Vector3(v.x * (1.0 - yy2 - zz2) + v.y * (xy2 - wz2) + v.z * (xz2 + wy2), v.x * (xy2 + wz2) + v.y * (1.0 - xx2 - zz2) + v.z * (yz2 - wx2), v.x * (xz2 - wy2) + v.y * (yz2 + wx2) + v.z * (1.0 - xx2 - yy2));
    }

    public Quaternion multipliedBy(Quaternion b) {
        return new Quaternion(this.x * b.w + b.x * this.w + this.y * b.z - this.z * b.y, this.y * b.w + b.y * this.w + this.z * b.x - this.x * b.z, this.z * b.w + b.z * this.w + this.x * b.y - this.y * b.x, this.w * b.w - this.x * b.x - this.y * b.y - this.z * b.z);
    }

    public Quaternion negative() {
        return new Quaternion(-this.x, -this.y, -this.z, -this.w);
    }

    public Quaternion inverse() {
        double len_sq = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        return new Quaternion(-this.x * len_sq, -this.y * len_sq, -this.z * len_sq, this.w * len_sq);
    }

    public Quaternion slerp(Quaternion end, double interpolationAmount) {
        double cosHalfTheta = this.w * end.w + this.x * end.x + this.y * end.y + this.z * end.z;
        if (cosHalfTheta < 0.0) {
            end = end.negative();
            cosHalfTheta = -cosHalfTheta;
        }
        if (cosHalfTheta > 0.999999999999) {
            return this;
        }
        double halfTheta = Math.acos(cosHalfTheta);
        double sinHalfTheta = Math.sqrt(1.0 - cosHalfTheta * cosHalfTheta);
        double aFraction = Math.sin((1.0 - interpolationAmount) * halfTheta) / sinHalfTheta;
        double bFraction = Math.sin(interpolationAmount * halfTheta) / sinHalfTheta;
        return new Quaternion(this.x * aFraction + end.x * bFraction, this.y * aFraction + end.y * bFraction, this.z * aFraction + end.z * bFraction, this.w * aFraction + end.w * bFraction);
    }

    public String toString() {
        return "(Quaternion: " + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }
}

