/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Brushable;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Beehive;
import org.bukkit.block.data.type.Cake;
import org.bukkit.block.data.type.DriedGhast;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.block.data.type.Snow;

public class MaterialLevel
extends MaterialProperty<ElementTag> {
    public static boolean describes(MaterialTag material) {
        BlockData data = material.getModernData();
        return data instanceof Levelled || data instanceof Cake || data instanceof Snow || data instanceof Farmland || data instanceof Beehive || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && data instanceof Brushable || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && data instanceof DriedGhast;
    }

    @Override
    public ElementTag getPropertyValue() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Cake) {
            Cake cake = (Cake)blockData;
            return new ElementTag(cake.getBites());
        }
        blockData = this.getBlockData();
        if (blockData instanceof Snow) {
            Snow snow = (Snow)blockData;
            return new ElementTag(snow.getLayers());
        }
        blockData = this.getBlockData();
        if (blockData instanceof Beehive) {
            Beehive beehive = (Beehive)blockData;
            return new ElementTag(beehive.getHoneyLevel());
        }
        blockData = this.getBlockData();
        if (blockData instanceof Farmland) {
            Farmland farmland = (Farmland)blockData;
            return new ElementTag(farmland.getMoisture());
        }
        blockData = this.getBlockData();
        if (blockData instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            return new ElementTag(levelled.getLevel());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && (blockData = this.getBlockData()) instanceof Brushable) {
            Brushable brushable = (Brushable)blockData;
            return new ElementTag(brushable.getDusted());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof DriedGhast) {
            DriedGhast driedGhast = (DriedGhast)blockData;
            return new ElementTag(driedGhast.getHydration());
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "level";
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        if (!mechanism.requireInteger()) {
            return;
        }
        int level = value.asInt();
        if (level < this.getMin() || level > this.getMax()) {
            mechanism.echoError("Level value '" + level + "' is not valid. Must be between " + this.getMin() + " and " + this.getMax() + " for material '" + this.getBlockData().getMaterial().name() + "'.");
            return;
        }
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Cake) {
            Cake cake = (Cake)blockData;
            cake.setBites(level);
        } else {
            blockData = this.getBlockData();
            if (blockData instanceof Snow) {
                Snow snow = (Snow)blockData;
                snow.setLayers(level);
            } else {
                blockData = this.getBlockData();
                if (blockData instanceof Beehive) {
                    Beehive beehive = (Beehive)blockData;
                    beehive.setHoneyLevel(level);
                } else {
                    blockData = this.getBlockData();
                    if (blockData instanceof Farmland) {
                        Farmland farmland = (Farmland)blockData;
                        farmland.setMoisture(level);
                    } else {
                        blockData = this.getBlockData();
                        if (blockData instanceof Levelled) {
                            Levelled levelled = (Levelled)blockData;
                            levelled.setLevel(level);
                        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && (blockData = this.getBlockData()) instanceof Brushable) {
                            Brushable brushable = (Brushable)blockData;
                            brushable.setDusted(level);
                        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof DriedGhast) {
                            DriedGhast driedGhast = (DriedGhast)blockData;
                            driedGhast.setHydration(level);
                        }
                    }
                }
            }
        }
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialLevel.class, ElementTag.class, "maximum_level", (attribute, material) -> new ElementTag(material.getMax()), new String[0]);
        PropertyParser.registerStaticTag(MaterialLevel.class, ElementTag.class, "minimum_level", (attribute, material) -> new ElementTag(material.getMin()), new String[0]);
        MaterialLevel.autoRegister("level", MaterialLevel.class, ElementTag.class, false, new String[0]);
    }

    public int getMax() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Cake) {
            Cake cake = (Cake)blockData;
            return cake.getMaximumBites();
        }
        blockData = this.getBlockData();
        if (blockData instanceof Snow) {
            Snow snow = (Snow)blockData;
            return snow.getMaximumLayers();
        }
        blockData = this.getBlockData();
        if (blockData instanceof Beehive) {
            Beehive beehive = (Beehive)blockData;
            return beehive.getMaximumHoneyLevel();
        }
        blockData = this.getBlockData();
        if (blockData instanceof Farmland) {
            Farmland farmland = (Farmland)blockData;
            return farmland.getMaximumMoisture();
        }
        blockData = this.getBlockData();
        if (blockData instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            return levelled.getMaximumLevel();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && (blockData = this.getBlockData()) instanceof Brushable) {
            Brushable brushable = (Brushable)blockData;
            return brushable.getMaximumDusted();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof DriedGhast) {
            DriedGhast driedGhast = (DriedGhast)blockData;
            return driedGhast.getMaximumHydration();
        }
        throw new UnsupportedOperationException();
    }

    public int getMin() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Snow) {
            Snow snow = (Snow)blockData;
            return snow.getMinimumLayers();
        }
        return 0;
    }
}

