/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;

public class EntityProfession
extends EntityProperty<ElementTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Villager || entity.getBukkitEntity() instanceof ZombieVillager;
    }

    @Override
    public ElementTag getPropertyValue() {
        Entity entity = this.getEntity();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            return Utilities.enumlikeToElement(villager.getProfession());
        }
        entity = this.getEntity();
        if (entity instanceof ZombieVillager) {
            ZombieVillager zombieVillager = (ZombieVillager)entity;
            return Utilities.enumlikeToElement(zombieVillager.getVillagerProfession());
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        if (!mechanism.requireEnum(Villager.Profession.class)) {
            return;
        }
        Entity entity = this.getEntity();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.setProfession(value.asEnum(Villager.Profession.class));
        } else {
            entity = this.getEntity();
            if (entity instanceof ZombieVillager) {
                ZombieVillager zombieVillager = (ZombieVillager)entity;
                zombieVillager.setVillagerProfession(value.asEnum(Villager.Profession.class));
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "profession";
    }

    public static void register() {
        EntityProfession.autoRegister("profession", EntityProfession.class, ElementTag.class, false, new String[0]);
    }
}

