/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Location;

public class StrikeCommand
extends AbstractCommand {
    public StrikeCommand() {
        this.setName("strike");
        this.setSyntax("strike [<location>] (no_damage) (silent)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
        this.setBooleansHandled("no_damage", "silent");
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addNotesOfType(LocationTag.class);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObjectTag("location");
        boolean noDamage = scriptEntry.argAsBoolean("no_damage");
        boolean silent = scriptEntry.argAsBoolean("silent");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), location, StrikeCommand.db("no_damage", noDamage), StrikeCommand.db("silent", silent));
        }
        if (noDamage) {
            location.getWorld().spigot().strikeLightningEffect((Location)location, silent);
        } else {
            location.getWorld().spigot().strikeLightning((Location)location, silent);
        }
    }
}

