/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import io.papermc.paper.event.player.PlayerTradeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerTradesWithMerchantScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerPurchaseEvent event;

    public PlayerTradesWithMerchantScriptEvent() {
        this.registerCouldMatcher("player trades with merchant");
        this.registerSwitches("result");
        this.registerDetermination(null, TradeTag.class, (evt, context, trade) -> evt.event.setTrade(trade.getRecipe()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        if (!path.tryObjectSwitch("result", new ItemTag(this.event.getTrade().getResult()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "merchant" -> {
                PlayerPurchaseEvent var5_4 = this.event;
                if (var5_4 instanceof PlayerTradeEvent) {
                    PlayerTradeEvent tradeEvent = (PlayerTradeEvent)var5_4;
                    yield new EntityTag((Entity)tradeEvent.getVillager());
                }
                yield null;
            }
            case "trade" -> new TradeTag(this.event.getTrade()).duplicate();
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void playerTradeEvent(PlayerPurchaseEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

