/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.npc;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.event.NavigationStuckEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NPCStuckScriptEvent
extends BukkitScriptEvent
implements Listener {
    public NavigationStuckEvent event;
    public NPCTag npc;

    public NPCStuckScriptEvent() {
        this.registerCouldMatcher("npc stuck");
        this.registerSwitches("npc");
        this.registerDetermination(null, ElementTag.class, (evt, context, action) -> evt.event.setAction((StuckAction)(action.asLowerString().equals("none") ? null : TeleportStuckAction.INSTANCE)));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryObjectSwitch("npc", this.npc)) {
            return false;
        }
        if (!this.runInCheck(path, this.npc.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, this.npc);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "action" -> new ElementTag(this.event.getAction() == TeleportStuckAction.INSTANCE ? "teleport" : "none");
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void navStuck(NavigationStuckEvent event) {
        this.npc = new NPCTag(event.getNPC());
        this.event = event;
        this.fire((Event)event);
    }
}

