/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.interfaces;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.nbt.CustomNBT;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.ShieldMeta;
import org.bukkit.map.MapView;

public abstract class ItemHelper {
    public abstract void setMaxStackSize(Material var1, int var2);

    public abstract Integer burnTime(Material var1);

    public abstract void registerStonecuttingRecipe(String var1, String var2, ItemStack var3, ItemStack[] var4, boolean var5);

    public abstract void registerFurnaceRecipe(String var1, String var2, ItemStack var3, ItemStack[] var4, float var5, int var6, String var7, boolean var8, String var9);

    public abstract void registerShapelessRecipe(String var1, String var2, ItemStack var3, List<ItemStack[]> var4, boolean[] var5, String var6);

    public abstract void setShapedRecipeIngredient(ShapedRecipe var1, char var2, ItemStack[] var3, boolean var4);

    public abstract String getJsonString(ItemStack var1);

    public String getLegacyHoverNbt(ItemTag item) {
        return item.getItemMeta().getAsString();
    }

    public JsonObject getRawHoverComponentsJson(ItemStack item) {
        throw new UnsupportedOperationException();
    }

    public ItemStack applyRawHoverComponentsJson(ItemStack item, JsonObject components) {
        throw new UnsupportedOperationException();
    }

    public abstract PlayerProfile getSkullSkin(ItemStack var1);

    public abstract ItemStack setSkullSkin(ItemStack var1, PlayerProfile var2);

    public abstract ItemStack addNbtData(ItemStack var1, String var2, BinaryTag var3);

    public abstract CompoundBinaryTag getNbtData(ItemStack var1);

    public abstract ItemStack setNbtData(ItemStack var1, CompoundBinaryTag var2);

    public CompoundBinaryTag getCustomData(ItemStack item) {
        return this.getNbtData(item);
    }

    public ItemStack setCustomData(ItemStack item, CompoundBinaryTag data) {
        return this.setNbtData(item, data);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundBinaryTag oldTag) {
        throw new UnsupportedOperationException();
    }

    public CompoundBinaryTag getEntityData(ItemStack item) {
        return this.getNbtData(item).getCompound("EntityTag", null);
    }

    public ItemStack setEntityData(ItemStack item, CompoundBinaryTag entityNbt, EntityType entityType) {
        boolean shouldRemove = entityNbt == null || entityNbt.isEmpty();
        CompoundBinaryTag nbt = this.getNbtData(item);
        if (shouldRemove && !nbt.contains("EntityTag")) {
            return item;
        }
        nbt = shouldRemove ? (CompoundBinaryTag)nbt.remove("EntityTag") : (CompoundBinaryTag)nbt.put("EntityTag", entityNbt);
        return this.setNbtData(item, nbt);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return CustomNBT.getNBTMaterials(item, "CanPlaceOn");
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        if (canPlaceOn == null) {
            return CustomNBT.clearNBT(item, "CanPlaceOn");
        }
        return CustomNBT.setNBTMaterials(item, "CanPlaceOn", canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return CustomNBT.getNBTMaterials(item, "CanDestroy");
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        if (canBreak == null) {
            return CustomNBT.clearNBT(item, "CanDestroy");
        }
        return CustomNBT.setNBTMaterials(item, "CanDestroy", canBreak);
    }

    public MapTag getRawComponentsPatch(ItemStack item, boolean excludeHandled) {
        throw new UnsupportedOperationException();
    }

    public ItemStack setRawComponentsPatch(ItemStack item, MapTag rawComponentsMap, int dataVersion, Consumer<String> errorHandler) {
        throw new UnsupportedOperationException();
    }

    public abstract void registerSmithingRecipe(String var1, ItemStack var2, ItemStack[] var3, boolean var4, ItemStack[] var5, boolean var6, ItemStack[] var7, boolean var8);

    public abstract void setInventoryItem(Inventory var1, ItemStack var2, int var3);

    public abstract String getDisplayName(ItemTag var1);

    public abstract List<String> getLore(ItemTag var1);

    public abstract void setDisplayName(ItemTag var1, String var2);

    public abstract void setLore(ItemTag var1, List<String> var2);

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        throw new UnsupportedOperationException();
    }

    public BlockData getPlacedBlock(Material material) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isValidMix(ItemStack var1, ItemStack var2);

    public Map<NamespacedKey, BrewingRecipe> getCustomBrewingRecipes() {
        throw new UnsupportedOperationException();
    }

    public byte[] renderMap(MapView mapView, Player player) {
        throw new UnsupportedOperationException();
    }

    public int getFoodPoints(Material itemType) {
        throw new UnsupportedOperationException();
    }

    public DyeColor getShieldColor(ItemStack item) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            return ((ShieldMeta)item.getItemMeta()).getBaseColor();
        }
        BlockStateMeta stateMeta = (BlockStateMeta)item.getItemMeta();
        return stateMeta.hasBlockState() ? ((Banner)stateMeta.getBlockState()).getBaseColor() : null;
    }

    public ItemStack setShieldColor(ItemStack item, DyeColor color) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            ShieldMeta shieldMeta = (ShieldMeta)item.getItemMeta();
            shieldMeta.setBaseColor(color);
            item.setItemMeta((ItemMeta)shieldMeta);
            return item;
        }
        if (color == null) {
            CompoundBinaryTag noStateNbt = (CompoundBinaryTag)this.getNbtData(item).remove("BlockEntityTag");
            return this.setNbtData(item, noStateNbt);
        }
        BlockStateMeta stateMeta = (BlockStateMeta)item.getItemMeta();
        Banner banner = (Banner)stateMeta.getBlockState();
        banner.setBaseColor(color);
        stateMeta.setBlockState((BlockState)banner);
        item.setItemMeta((ItemMeta)stateMeta);
        return item;
    }

    public void blockRecipeFinalization() {
    }

    public void restoreRecipeFinalization() {
    }

    public void removeRecipes(List<NamespacedKey> keys) {
    }

    public void registerOtherRecipe(Recipe recipe) {
    }

    public record BrewingRecipe(RecipeChoice input, RecipeChoice ingredient, ItemStack result) {
    }
}

