/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.math.BigDecimal;

public class Comparable {
    public static Operator getOperatorFor(String text) {
        switch (CoreUtilities.toLowerCase(text)) {
            case "equals": 
            case "==": 
            case "=": {
                return Operator.EQUALS;
            }
            case "or_more": 
            case ">=": {
                return Operator.OR_MORE;
            }
            case "or_less": 
            case "<=": {
                return Operator.OR_LESS;
            }
            case "more": 
            case ">": {
                return Operator.MORE;
            }
            case "less": 
            case "<": {
                return Operator.LESS;
            }
            case "contains": {
                return Operator.CONTAINS;
            }
            case "in": {
                return Operator.IN;
            }
            case "matches": {
                return Operator.MATCHES;
            }
        }
        return null;
    }

    private static boolean compareDecimal(ObjectTag objA, ObjectTag objB, Operator operator, TagContext context) {
        block8: {
            try {
                BigDecimal bigDecA = objA.asElement().asBigDecimal();
                BigDecimal bigDecB = objB.asElement().asBigDecimal();
                int compared = bigDecA.compareTo(bigDecB);
                switch (operator.ordinal()) {
                    case 4: {
                        return compared < 0;
                    }
                    case 3: {
                        return compared > 0;
                    }
                    case 2: {
                        return compared <= 0;
                    }
                    case 1: {
                        return compared >= 0;
                    }
                }
            }
            catch (NumberFormatException ex) {
                if (!context.showErrors()) break block8;
                Debug.echoError("Cannot compare as numbers '" + String.valueOf(objA) + "' vs '" + String.valueOf(objB) + "' - one or both values are not numerical. Returning false.");
            }
        }
        return false;
    }

    private static boolean listContains(ObjectTag listObj, ObjectTag entry, TagContext context) {
        ListTag list = null;
        MapTag map = null;
        if (listObj instanceof ListTag) {
            list = (ListTag)listObj;
        } else if (listObj instanceof MapTag) {
            map = (MapTag)listObj;
        } else {
            String text = listObj.toString();
            if (text.startsWith("li@")) {
                list = ListTag.valueOf(text, context);
            } else if (text.startsWith("map@") || text.startsWith("[")) {
                map = MapTag.valueOf(text, context);
            } else {
                list = ListTag.valueOf(text, context);
            }
        }
        String search = entry.toString();
        if (list != null) {
            for (String string : list) {
                if (!CoreUtilities.equalsIgnoreCase(string, search)) continue;
                return true;
            }
        } else if (map != null) {
            return map.getDeepObject(search) != null;
        }
        return false;
    }

    public static boolean compare(ObjectTag objA, ObjectTag objB, Operator operator, boolean negative, TagContext context) {
        boolean outcome;
        switch (operator.ordinal()) {
            case 0: {
                outcome = CoreUtilities.equalsIgnoreCase(objA.toString(), objB.toString());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                outcome = Comparable.compareDecimal(objA, objB, operator, context);
                break;
            }
            case 5: {
                outcome = Comparable.listContains(objA, objB, context);
                break;
            }
            case 6: {
                outcome = Comparable.listContains(objB, objA, context);
                break;
            }
            case 7: {
                outcome = objA.tryAdvancedMatcher(objB.toString(), context);
                break;
            }
            default: {
                return false;
            }
        }
        return negative ? !outcome : outcome;
    }

    public static enum Operator {
        EQUALS,
        OR_MORE,
        OR_LESS,
        MORE,
        LESS,
        CONTAINS,
        IN,
        MATCHES;

    }
}

