/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Warden;

public class MultiVersionHelper1_19 {
    public static boolean colorIsApplicable(EntityType type) {
        return type == EntityType.FROG || Boat.class.isAssignableFrom(type.getEntityClass());
    }

    public static String getColor(Entity entity, boolean includeDeprecated) {
        if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            return String.valueOf(frog.getVariant());
        }
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
                if (!includeDeprecated) {
                    return null;
                }
                BukkitImplDeprecations.gettingBoatType.warn();
            }
            return boat.getBoatType().name();
        }
        return null;
    }

    public static ListTag getAllowedColors(EntityType type) {
        if (type == EntityType.FROG) {
            return Utilities.listTypes(Frog.Variant.class);
        }
        if (Boat.class.isAssignableFrom(type.getEntityClass())) {
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
                BukkitImplDeprecations.gettingBoatType.warn();
            }
            return Utilities.listTypes(Boat.Type.class);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setColor(Entity entity, Mechanism mech) {
        if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            if (Utilities.requireEnumlike(mech, Frog.Variant.class)) {
                frog.setVariant(Utilities.elementToEnumlike(mech.getValue(), Frog.Variant.class));
                return;
            }
        }
        if (!(entity instanceof Boat)) return;
        Boat boat = (Boat)entity;
        if (!mech.requireEnum(Boat.Type.class)) return;
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            BukkitImplDeprecations.settingBoatType.warn(mech.context);
            return;
        }
        boat.setBoatType(mech.getValue().asEnum(Boat.Type.class));
    }

    public static MapTag interactionToMap(Interaction.PreviousInteraction interaction, World world) {
        if (interaction == null) {
            return null;
        }
        MapTag result = new MapTag();
        result.putObject("player", (ObjectTag)new PlayerTag(interaction.getPlayer()));
        result.putObject("duration", (ObjectTag)new DurationTag((double)(world.getGameTime() - interaction.getTimestamp()) / 20.0));
        result.putObject("raw_game_time", (ObjectTag)new ElementTag(interaction.getTimestamp()));
        return result;
    }

    public static ElementTag getWardenAngerLevel(Warden warden) {
        return new ElementTag((Enum<?>)warden.getAngerLevel());
    }
}

