/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Brushable;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Beehive;
import org.bukkit.block.data.type.Cake;
import org.bukkit.block.data.type.Farmland;
import org.bukkit.block.data.type.Snow;

public class MaterialLevel
extends MaterialProperty<ElementTag> {
    public static boolean describes(MaterialTag material) {
        BlockData data = material.getModernData();
        return data instanceof Levelled || data instanceof Cake || data instanceof Snow || data instanceof Farmland || data instanceof Beehive || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && data instanceof Brushable;
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "level";
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        if (!mechanism.requireInteger()) {
            return;
        }
        int level = value.asInt();
        if (level < this.getMin() || level > this.getMax()) {
            mechanism.echoError("Level value '" + level + "' is not valid. Must be between " + this.getMin() + " and " + this.getMax() + " for material '" + this.getBlockData().getMaterial().name() + "'.");
            return;
        }
        this.setCurrent(level);
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialLevel.class, ElementTag.class, "maximum_level", (attribute, material) -> new ElementTag(material.getMax()), new String[0]);
        PropertyParser.registerStaticTag(MaterialLevel.class, ElementTag.class, "minimum_level", (attribute, material) -> new ElementTag(material.getMin()), new String[0]);
        MaterialLevel.autoRegister("level", MaterialLevel.class, ElementTag.class, false, new String[0]);
    }

    public Levelled getLevelled() {
        return (Levelled)this.getBlockData();
    }

    public boolean isCake() {
        return this.getBlockData() instanceof Cake;
    }

    public Cake getCake() {
        return (Cake)this.getBlockData();
    }

    public boolean isSnow() {
        return this.getBlockData() instanceof Snow;
    }

    public Snow getSnow() {
        return (Snow)this.getBlockData();
    }

    public boolean isHive() {
        return this.getBlockData() instanceof Beehive;
    }

    public Beehive getHive() {
        return (Beehive)this.getBlockData();
    }

    public boolean isFarmland() {
        return this.getBlockData() instanceof Farmland;
    }

    public Farmland getFarmland() {
        return (Farmland)this.getBlockData();
    }

    public boolean isBrushable() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && this.getBlockData() instanceof Brushable;
    }

    public int getCurrent() {
        if (this.isCake()) {
            return this.getCake().getBites();
        }
        if (this.isSnow()) {
            return this.getSnow().getLayers();
        }
        if (this.isHive()) {
            return this.getHive().getHoneyLevel();
        }
        if (this.isFarmland()) {
            return this.getFarmland().getMoisture();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && this.isBrushable()) {
            return ((Brushable)this.getBlockData()).getDusted();
        }
        return this.getLevelled().getLevel();
    }

    public int getMax() {
        if (this.isCake()) {
            return this.getCake().getMaximumBites();
        }
        if (this.isSnow()) {
            return this.getSnow().getMaximumLayers();
        }
        if (this.isHive()) {
            return this.getHive().getMaximumHoneyLevel();
        }
        if (this.isFarmland()) {
            return this.getFarmland().getMaximumMoisture();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && this.isBrushable()) {
            return ((Brushable)this.getBlockData()).getMaximumDusted();
        }
        return this.getLevelled().getMaximumLevel();
    }

    public int getMin() {
        if (this.isSnow()) {
            return this.getSnow().getMinimumLayers();
        }
        return 0;
    }

    public void setCurrent(int level) {
        if (this.isCake()) {
            this.getCake().setBites(level);
            return;
        }
        if (this.isSnow()) {
            this.getSnow().setLayers(level);
            return;
        }
        if (this.isHive()) {
            this.getHive().setHoneyLevel(level);
            return;
        }
        if (this.isFarmland()) {
            this.getFarmland().setMoisture(level);
            return;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && this.isBrushable()) {
            ((Brushable)this.getBlockData()).setDusted(level);
            return;
        }
        this.getLevelled().setLevel(level);
    }
}

