/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import io.papermc.paper.event.block.DragonEggFormEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class DragonEggFormScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public EntityTag entity;
    public DragonEggFormEvent event;

    public DragonEggFormScriptEvent() {
        this.registerCouldMatcher("dragon egg forms");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.entity;
            case "location" -> this.location;
            case "end_portal_location" -> new LocationTag(this.event.getDragonBattle().getEndPortalLocation());
            case "previously_killed" -> new ElementTag(this.event.getDragonBattle().hasBeenPreviouslyKilled());
            case "respawn_phase" -> new ElementTag((Enum<?>)this.event.getDragonBattle().getRespawnPhase());
            case "healing_crystals" -> new ListTag(this.event.getDragonBattle().getHealingCrystals(), EntityTag::new);
            case "respawn_crystals" -> new ListTag(this.event.getDragonBattle().getRespawnCrystals(), EntityTag::new);
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onDragonEggForms(DragonEggFormEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.entity = new EntityTag((Entity)event.getDragonBattle().getEnderDragon());
        this.event = event;
        EntityTag.rememberEntity(this.entity.getBukkitEntity());
        this.fire((Event)event);
        EntityTag.forgetEntity(this.entity.getBukkitEntity());
    }
}

