/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.FluidLevelChangeEvent;

public class LiquidLevelChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag old_material;
    public FluidLevelChangeEvent event;

    public LiquidLevelChangeScriptEvent() {
        this.registerCouldMatcher("liquid|lava|water level changes");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return !path.eventLower.startsWith("block");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String mat = path.eventArgLowerAt(0);
        if (!mat.equals("liquid") && !this.old_material.tryAdvancedMatcher(mat, path.context)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "old_material": {
                return this.old_material;
            }
            case "new_material": {
                return new MaterialTag(this.event.getNewData());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLiquidLevelChange(FluidLevelChangeEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.old_material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

