/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.server;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class InternalEventScriptEvent
extends BukkitScriptEvent
implements Listener {
    public InternalEventScriptEvent() {
        this.registerCouldMatcher("internal bukkit event");
        this.registerSwitches("event");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        return path.switches.containsKey("event");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        return this.currentEvent.getClass().getCanonicalName().equals(path.switches.get("event"));
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "fields": {
                if (!CoreConfiguration.allowReflectionFieldReads) {
                    return null;
                }
                BukkitImplDeprecations.internalEventReflectionContext.warn();
                ListTag result = new ListTag();
                for (Class<?> c = this.currentEvent.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                    for (Field field : ReflectionHelper.getFields(c).getAllFields()) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        result.addObject(new ElementTag(field.getName(), true));
                    }
                }
                return result;
            }
        }
        if (name.startsWith("field_")) {
            if (!CoreConfiguration.allowReflectionFieldReads) {
                return null;
            }
            BukkitImplDeprecations.internalEventReflectionContext.warn();
            String fName = CoreUtilities.toLowerCase(name.substring("field_".length()));
            for (Class<?> c = this.currentEvent.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                ReflectionHelper.FieldCache fields = ReflectionHelper.getFields(c);
                for (Field field : fields.getAllFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || !CoreUtilities.toLowerCase(field.getName()).equals(fName)) continue;
                    Object val = null;
                    try {
                        val = field.get(this.currentEvent);
                    }
                    catch (Throwable ex) {
                        Debug.echoError(ex);
                    }
                    if (val == null) continue;
                    return CoreUtilities.objectToTagForm(val, CoreUtilities.errorButNoDebugContext, false, false, false);
                }
            }
        }
        return super.getContext(name);
    }

    @Override
    public void destroy() {
        if (this.registeredHandlers != null) {
            for (Map.Entry handler : this.registeredHandlers) {
                ((HandlerList)handler.getValue()).unregister((RegisteredListener)handler.getKey());
            }
            this.registeredHandlers = null;
        }
    }

    @Override
    public void init() {
        this.registeredHandlers = new ArrayList();
        HashSet<String> eventsGrabbed = new HashSet<String>();
        for (ScriptEvent.ScriptPath path : new ArrayList(this.eventPaths)) {
            String eventName = path.switches.get("event");
            if (!eventsGrabbed.add(eventName)) continue;
            try {
                Class<?> clazz = Class.forName(eventName);
                if (!Event.class.isAssignableFrom(clazz)) {
                    Debug.echoError("Cannot initialize Internal Bukkit Event for event '" + eventName + "': that class is not an event class.");
                    return;
                }
                EventPriority priority = EventPriority.NORMAL;
                String bukkitPriority = path.switches.get("bukkit_priority");
                if (bukkitPriority != null) {
                    try {
                        priority = EventPriority.valueOf((String)bukkitPriority.toUpperCase());
                    }
                    catch (IllegalArgumentException ex) {
                        Debug.echoError("Invalid 'bukkit_priority' switch for event '" + path.event + "' in script '" + path.container.getName() + "'.");
                        Debug.echoError(ex);
                    }
                }
                InternalEventScriptEvent handler = (InternalEventScriptEvent)this.clone();
                handler.eventPaths = new ArrayList();
                handler.eventPaths.add(path);
                handler.registeredHandlers = null;
                handler.initForPriority(priority, this, clazz);
                this.eventPaths.remove(path);
            }
            catch (ClassNotFoundException ex) {
                Debug.echoError("Cannot initialize Internal Bukkit Event for event '" + eventName + "': that event class does not exist.");
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
    }

    public void initForPriority(EventPriority priority, InternalEventScriptEvent baseEvent, Class<? extends Event> clazz) {
        Denizen plugin = Denizen.getInstance();
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners((Listener)this, (Plugin)plugin).entrySet()) {
            for (RegisteredListener registeredListener : (Set)entry.getValue()) {
                RegisteredListener newListener = new RegisteredListener((Listener)this, InternalEventScriptEvent.getExecutor(registeredListener), priority, (Plugin)plugin, false);
                HandlerList handlers = InternalEventScriptEvent.getEventListeners(clazz);
                handlers.register(newListener);
                baseEvent.registeredHandlers.add(new AbstractMap.SimpleEntry<RegisteredListener, HandlerList>(newListener, handlers));
            }
        }
    }

    @EventHandler
    public void onEventHappens(Event event) {
        this.fire(event);
    }
}

