/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;

public class EntityMaterial
extends EntityProperty<MaterialTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Enderman || entity.getBukkitEntity() instanceof Minecart || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && entity.getBukkitEntity() instanceof BlockDisplay;
    }

    @Override
    public MaterialTag getPropertyValue() {
        BlockData blockData = null;
        Entity entity = this.getEntity();
        if (entity instanceof Enderman) {
            Enderman enderman = (Enderman)entity;
            blockData = enderman.getCarriedBlock();
        } else {
            entity = this.getEntity();
            if (entity instanceof Minecart) {
                Minecart minecart = (Minecart)entity;
                blockData = minecart.getDisplayBlockData();
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                blockData = this.as(BlockDisplay.class).getBlock();
            }
        }
        return blockData != null ? new MaterialTag(blockData) : new MaterialTag(Material.AIR);
    }

    @Override
    public boolean isDefaultValue(MaterialTag value) {
        return value.getMaterial() == Material.AIR;
    }

    @Override
    public void setPropertyValue(MaterialTag value, Mechanism mechanism) {
        Entity entity = this.getEntity();
        if (entity instanceof Enderman) {
            Enderman enderman = (Enderman)entity;
            enderman.setCarriedBlock(value.getModernData());
        } else {
            entity = this.getEntity();
            if (entity instanceof Minecart) {
                Minecart minecart = (Minecart)entity;
                minecart.setDisplayBlockData(value.getModernData());
            } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
                this.as(BlockDisplay.class).setBlock(value.getModernData());
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "material";
    }

    public static void register() {
        EntityMaterial.autoRegister("material", EntityMaterial.class, MaterialTag.class, false, new String[0]);
    }
}

