/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;

public class PlayerChangesWorldScriptEvent
extends BukkitScriptEvent
implements Listener {
    public WorldTag origin_world;
    public WorldTag destination_world;
    public PlayerChangedWorldEvent event;

    public PlayerChangesWorldScriptEvent() {
        this.registerCouldMatcher("player changes world (from <world>) (to <world>)");
        this.registerSwitches("from", "to");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String[] data = path.eventArgsLower;
        for (int index = 3; index < data.length; ++index) {
            if (data[index].equals("from")) {
                BukkitImplDeprecations.playerChangesWorldSwitches.warn(this.getTagContext(path));
                if (this.origin_world.tryAdvancedMatcher(data[index + 1], path.context)) continue;
                return false;
            }
            if (!data[index].equals("to")) continue;
            BukkitImplDeprecations.playerChangesWorldSwitches.warn(this.getTagContext(path));
            if (this.destination_world.tryAdvancedMatcher(data[index + 1], path.context)) continue;
            return false;
        }
        if (!path.tryObjectSwitch("from", this.origin_world)) {
            return false;
        }
        if (!path.tryObjectSwitch("to", this.destination_world)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "origin_world" -> this.origin_world;
            case "destination_world" -> this.destination_world;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerChangesWorld(PlayerChangedWorldEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.origin_world = new WorldTag(event.getFrom());
        this.destination_world = new WorldTag(event.getPlayer().getWorld());
        this.event = event;
        this.fire((Event)event);
    }
}

