/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.paper.PaperModule;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerSetSpawnScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerSetSpawnEvent event;

    public PlayerSetSpawnScriptEvent() {
        this.registerCouldMatcher("player sets spawn");
        this.registerSwitches(new String[]{"cause"});
        this.registerOptionalDetermination("forced", ElementTag.class, (evt, context, value) -> {
            if (value.isBoolean()) {
                evt.event.setForced(value.asBoolean());
                return true;
            }
            return false;
        });
        this.registerDetermination("message", ElementTag.class, (evt, context, message) -> evt.event.setNotification(PaperModule.parseFormattedText(message.toString(), ChatColor.WHITE)));
        this.registerOptionalDetermination("notify", ElementTag.class, (evt, context, value) -> {
            if (value.isBoolean()) {
                evt.event.setNotifyPlayer(value.asBoolean());
                return true;
            }
            return false;
        });
        this.registerDetermination(null, LocationTag.class, (evt, context, location) -> {
            evt.event.setLocation((Location)location);
            evt.event.setForced(true);
        });
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getLocation())) {
            return false;
        }
        if (!PlayerSetSpawnScriptEvent.runGenericSwitchCheck((ScriptEvent.ScriptPath)path, (String)"cause", (String)this.event.getCause().toString())) {
            return false;
        }
        return super.matches(path);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "cause" -> new ElementTag((Enum)this.event.getCause());
            case "forced" -> new ElementTag(this.event.isForced());
            case "location" -> {
                if (this.event.getLocation() != null) {
                    yield new LocationTag(this.event.getLocation());
                }
                yield null;
            }
            case "message" -> {
                if (this.event.getNotification() != null) {
                    yield new ElementTag(PaperModule.stringifyComponent(this.event.getNotification()), true);
                }
                yield null;
            }
            case "notify" -> new ElementTag(this.event.willNotifyPlayer());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerSetsSpawn(PlayerSetSpawnEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

