/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.block.TargetHitEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class TargetBlockHitScriptEvent
extends BukkitScriptEvent
implements Listener {
    public TargetHitEvent event;
    public LocationTag hitBlock;
    public EntityTag projectile;
    public EntityTag shooter;

    public TargetBlockHitScriptEvent() {
        this.registerCouldMatcher("target block hit");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, (Location)this.hitBlock)) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "projectile" -> this.projectile.getDenizenObject();
            case "hit_block" -> this.hitBlock;
            case "hit_face" -> {
                if (this.event.getHitBlockFace() != null) {
                    yield new LocationTag(this.event.getHitBlockFace().getDirection());
                }
                yield null;
            }
            case "shooter" -> {
                if (this.shooter != null) {
                    yield this.shooter.getDenizenObject();
                }
                yield null;
            }
            case "strength" -> new ElementTag(this.event.getSignalStrength());
            default -> super.getContext(name);
        };
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.shooter);
    }

    @EventHandler
    public void onProjectileHit(TargetHitEvent event) {
        this.event = event;
        this.projectile = new EntityTag((Entity)event.getEntity());
        this.hitBlock = new LocationTag(event.getHitBlock().getLocation());
        this.shooter = this.projectile.getShooter();
        this.fire((Event)event);
    }
}

