/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.interfaces.ChunkHelper;
import com.denizenscript.denizen.nms.v1_17.impl.BiomeNMSImpl;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMapChunk;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.BiomeStorage;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;

public class ChunkHelperImpl
implements ChunkHelper {
    public static final Field chunkProviderServerThreadField = ReflectionHelper.getFields(ChunkProviderServer.class).getFirstOfType(Thread.class);
    public static final MethodHandle chunkProviderServerThreadFieldSetter = ReflectionHelper.getFinalSetterForFirstOfType(ChunkProviderServer.class, Thread.class);
    public static final Field worldThreadField = ReflectionHelper.getFields(World.class).getFirstOfType(Thread.class);
    public static final MethodHandle worldThreadFieldSetter = ReflectionHelper.getFinalSetterForFirstOfType(World.class, Thread.class);
    public Thread resetServerThread;

    public void changeChunkServerThread(org.bukkit.World world) {
        if (TagManager.tagThread == null) {
            return;
        }
        if (this.resetServerThread != null) {
            return;
        }
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ChunkProviderServer provider = nmsWorld.getChunkProvider();
        try {
            this.resetServerThread = (Thread)chunkProviderServerThreadField.get(provider);
            chunkProviderServerThreadFieldSetter.invoke(provider, Thread.currentThread());
            worldThreadFieldSetter.invoke(nmsWorld, Thread.currentThread());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void restoreServerThread(org.bukkit.World world) {
        if (TagManager.tagThread == null) {
            return;
        }
        if (this.resetServerThread == null) {
            return;
        }
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ChunkProviderServer provider = nmsWorld.getChunkProvider();
        try {
            chunkProviderServerThreadFieldSetter.invoke(provider, this.resetServerThread);
            worldThreadFieldSetter.invoke(nmsWorld, this.resetServerThread);
            this.resetServerThread = null;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void refreshChunkSections(org.bukkit.Chunk chunk) {
        PacketPlayOutMapChunk packet = new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle());
        ChunkCoordIntPair pos = new ChunkCoordIntPair(chunk.getX(), chunk.getZ());
        PlayerChunk playerChunk = (PlayerChunk)((CraftWorld)chunk.getWorld()).getHandle().getChunkProvider().a.l.get(pos.pair());
        if (playerChunk == null) {
            return;
        }
        playerChunk.y.a(pos, false).forEach(player -> player.b.sendPacket((Packet)packet));
    }

    public int[] getHeightMap(org.bukkit.Chunk chunk) {
        HeightMap map = (HeightMap)((CraftChunk)chunk).getHandle().j.get(HeightMap.Type.e);
        int[] outputMap = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                outputMap[x * 16 + y] = map.a(x, y);
            }
        }
        return outputMap;
    }

    public void setAllBiomes(org.bukkit.Chunk chunk, BiomeNMS biome) {
        BiomeBase nmsBiome = ((BiomeNMSImpl)biome).biomeBase;
        Chunk nmsChunk = ((CraftChunk)chunk).getHandle();
        BiomeStorage biomeContainer = nmsChunk.getBiomeIndex();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 64; ++y) {
                for (int z = 0; z < 4; ++z) {
                    biomeContainer.setBiome(x, y, z, nmsBiome);
                }
            }
        }
        nmsChunk.markDirty();
    }
}

