/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_21.helpers.AdvancementHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.AnimationHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.ChunkHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.CustomEntityHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.EnchantmentHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.EntityHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.FishingHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.PlayerHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.WorldHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.BiomeNMSImpl;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_21.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QuaternionTag;
import com.denizenscript.denizencore.scripts.commands.core.ReflectionSetCommand;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.Vector3f;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.BossBattle;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R4.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftNamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.joml.Quaternionf;
import org.spigotmc.AsyncCatcher;

public class Handler
extends NMSHandler {
    private final ProfileEditor profileEditor = new ProfileEditorImpl();
    private boolean wasAsyncCatcherEnabled;
    public static MethodHandle PAPER_INVENTORY_TITLE_GETTER;
    public static MethodHandle AbstractContainerMenu_title_SETTER;
    public static final Class MINECRAFT_INVENTORY;
    public static final Field INVENTORY_TITLE;
    public static final Field ENTITY_BUKKITYENTITY;
    public static MethodHandle BOSSBAR_ID_SETTER;

    public Handler() {
        advancementHelper = new AdvancementHelperImpl();
        animationHelper = new AnimationHelperImpl();
        blockHelper = new BlockHelperImpl();
        chunkHelper = new ChunkHelperImpl();
        customEntityHelper = new CustomEntityHelperImpl();
        entityHelper = new EntityHelperImpl();
        fishingHelper = new FishingHelperImpl();
        itemHelper = new ItemHelperImpl();
        packetHelper = new PacketHelperImpl();
        playerHelper = new PlayerHelperImpl();
        worldHelper = new WorldHelperImpl();
        enchantmentHelper = new EnchantmentHelperImpl();
        Handler.registerConversion(ItemTag.class, net.minecraft.world.item.ItemStack.class, item -> CraftItemStack.asNMSCopy((ItemStack)item.getItemStack()));
        Handler.registerConversion(ElementTag.class, IChatBaseComponent.class, element -> Handler.componentToNMS(FormattedTextHelper.parse((String)element.asString(), (ChatColor)ChatColor.WHITE)));
        Handler.registerConversion(MaterialTag.class, IBlockData.class, material -> ((CraftBlockData)material.getModernData()).getState());
        Handler.registerConversion(LocationTag.class, Vector3f.class, location -> new Vector3f((float)location.getX(), (float)location.getY(), (float)location.getZ()));
        Handler.registerConversion(LocationTag.class, BlockPosition.class, CraftLocation::toBlockPosition);
        Handler.registerConversion(MapTag.class, NBTTagCompound.class, map -> {
            NBTTagCompound nBTTagCompound;
            Tag patt0$temp = ItemRawNBT.convertObjectToNbt((String)map.identify(), (TagContext)CoreUtilities.noDebugContext, (String)"(item).");
            if (patt0$temp instanceof CompoundTagImpl) {
                CompoundTagImpl compoundTag = (CompoundTagImpl)patt0$temp;
                nBTTagCompound = compoundTag.toNMSTag();
            } else {
                nBTTagCompound = null;
            }
            return nBTTagCompound;
        });
        Handler.registerConversion(LocationTag.class, org.joml.Vector3f.class, location -> new org.joml.Vector3f((float)location.getX(), (float)location.getY(), (float)location.getZ()));
        Handler.registerConversion(QuaternionTag.class, Quaternionf.class, quaternion -> new Quaternionf(quaternion.x, quaternion.y, quaternion.z, quaternion.w));
    }

    public static <DT extends ObjectTag, JT> void registerConversion(Class<DT> denizenType, Class<JT> javaType, Function<DT, JT> convertor) {
        ReflectionSetCommand.typeConverters.put(javaType, objectTag -> {
            ObjectTag denizenObject = objectTag.asType(denizenType, CoreUtilities.noDebugContext);
            return denizenObject != null ? convertor.apply(denizenObject) : null;
        });
    }

    public void disableAsyncCatcher() {
        this.wasAsyncCatcherEnabled = AsyncCatcher.enabled;
        AsyncCatcher.enabled = false;
    }

    public void undisableAsyncCatcher() {
        AsyncCatcher.enabled = this.wasAsyncCatcherEnabled;
    }

    public boolean isCorrectMappingsCode() {
        return CraftMagicNumbers.INSTANCE.getMappingsVersion().equals("7ecad754373a5fbc43d381d7450c53a5");
    }

    public double[] getRecentTps() {
        return ((CraftServer)Bukkit.getServer()).getServer().recentTps;
    }

    public CompoundTag createCompoundTag(Map<String, Tag> value) {
        return new CompoundTagImpl(value);
    }

    public CompoundTag parseSNBT(String snbt) {
        try {
            return CompoundTagImpl.fromNMSTag(MojangsonParser.a((String)snbt));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public Sidebar createSidebar(Player player) {
        return new SidebarImpl(player);
    }

    public BlockLight createBlockLight(Location location, int lightLevel, long ticks) {
        return BlockLightImpl.createLight(location, lightLevel, ticks);
    }

    public PlayerProfile fillPlayerProfile(PlayerProfile playerProfile) {
        if (playerProfile == null) {
            return null;
        }
        if (playerProfile.getName() == null && playerProfile.getUniqueId() == null) {
            return playerProfile;
        }
        if (playerProfile.hasTexture() && playerProfile.hasTextureSignature() && playerProfile.getName() != null && playerProfile.getUniqueId() != null) {
            return playerProfile;
        }
        try {
            Property textures;
            GameProfile profile = null;
            DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
            if (playerProfile.getUniqueId() != null) {
                profile = minecraftServer.at().a(playerProfile.getUniqueId()).orElse(null);
            }
            if (profile == null && playerProfile.getName() != null) {
                profile = minecraftServer.at().a(playerProfile.getName()).orElse(null);
            }
            if (profile == null) {
                profile = ProfileEditorImpl.getGameProfileNoProperties(playerProfile);
            }
            Property property = textures = profile.getProperties().containsKey((Object)"textures") ? (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null) : null;
            if (textures == null || !textures.hasSignature() || profile.getName() == null || profile.getId() == null) {
                ProfileResult actualProfile = minecraftServer.aq().fetchProfile(profile.getId(), true);
                if (actualProfile == null) {
                    return null;
                }
                profile = actualProfile.profile();
                textures = profile.getProperties().containsKey((Object)"textures") ? (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null) : null;
            }
            return new PlayerProfile(profile.getName(), profile.getId(), textures == null ? null : textures.value(), textures == null ? null : textures.signature());
        }
        catch (Exception e) {
            if (CoreConfiguration.debugVerbose) {
                Debug.echoError((Throwable)e);
            }
            return null;
        }
    }

    public String getTitle(Inventory inventory) {
        IInventory nms = ((CraftInventory)inventory).getInventory();
        if (inventory instanceof CraftInventoryCustom && Denizen.supportsPaper) {
            try {
                if (PAPER_INVENTORY_TITLE_GETTER == null) {
                    PAPER_INVENTORY_TITLE_GETTER = ReflectionHelper.getMethodHandle((Class)nms.getClass(), (String)"title", (Class[])new Class[0]);
                }
                return PaperAPITools.instance.parseComponent(PAPER_INVENTORY_TITLE_GETTER.invoke(nms));
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if (nms instanceof INamableTileEntity) {
            return CraftChatMessage.fromComponent((IChatBaseComponent)((INamableTileEntity)nms).P_());
        }
        if (MINECRAFT_INVENTORY.isInstance(nms)) {
            try {
                return (String)INVENTORY_TITLE.get(nms);
            }
            catch (IllegalAccessException e) {
                Debug.echoError((Throwable)e);
            }
        }
        return "Chest";
    }

    public void setInventoryTitle(InventoryView view, String title) {
        Container menu = ((CraftInventoryView)view).getHandle();
        try {
            AbstractContainerMenu_title_SETTER.invoke(menu, Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.DARK_GRAY)));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public PlayerProfile getPlayerProfile(Player player) {
        GameProfile gameProfile = ((CraftPlayer)player).getProfile();
        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(gameProfile.getName(), gameProfile.getId(), property != null ? property.value() : null, property != null ? property.signature() : null);
    }

    public ProfileEditor getProfileEditor() {
        return this.profileEditor;
    }

    public List<BiomeNMS> getBiomes(World world) {
        WorldServer level = ((CraftWorld)world).getHandle();
        ArrayList<BiomeNMS> output = new ArrayList<BiomeNMS>();
        for (MinecraftKey key : level.J_().f(Registries.aG).i()) {
            output.add(new BiomeNMSImpl(level, CraftNamespacedKey.fromMinecraft((MinecraftKey)key)));
        }
        return output;
    }

    public BiomeNMS getBiomeNMS(World world, NamespacedKey key) {
        BiomeNMSImpl impl = new BiomeNMSImpl(((CraftWorld)world).getHandle(), key);
        if (impl.biomeHolder == null) {
            return null;
        }
        return impl;
    }

    public BiomeNMS getBiomeAt(Block block) {
        WorldServer level = ((CraftWorld)block.getWorld()).getHandle();
        Holder biome = level.getNoiseBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2);
        MinecraftKey key = level.J_().f(Registries.aG).b((Object)((BiomeBase)biome.a()));
        return new BiomeNMSImpl(level, CraftNamespacedKey.fromMinecraft((MinecraftKey)key));
    }

    public ArrayList<String> containerListFlags(PersistentDataContainer container, String prefix) {
        prefix = "denizen:" + (String)prefix;
        ArrayList<String> output = new ArrayList<String>();
        for (String key : ((CraftPersistentDataContainer)container).getRaw().keySet()) {
            if (!key.startsWith((String)prefix)) continue;
            output.add(key.substring(((String)prefix).length()));
        }
        return output;
    }

    public boolean containerHas(PersistentDataContainer container, String key) {
        return ((CraftPersistentDataContainer)container).getRaw().containsKey(key);
    }

    public String containerGetString(PersistentDataContainer container, String key) {
        NBTBase base = (NBTBase)((CraftPersistentDataContainer)container).getRaw().get(key);
        if (base instanceof NBTTagString) {
            return (String)base.p_().get();
        }
        if (base instanceof NBTTagByteArray) {
            return new String(((NBTTagByteArray)base).e(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public UUID getBossbarUUID(BossBar bar) {
        return ((CraftBossBar)bar).getHandle().i();
    }

    public void setBossbarUUID(BossBar bar, UUID id) {
        try {
            BOSSBAR_ID_SETTER.invoke(((CraftBossBar)bar).getHandle(), id);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static BaseComponent[] componentToSpigot(IChatBaseComponent nms) {
        if (nms == null) {
            return null;
        }
        return FormattedTextHelper.parseJson((String)CraftChatMessage.toJSON((IChatBaseComponent)nms));
    }

    public static IChatBaseComponent componentToNMS(BaseComponent[] spigot) {
        if (spigot == null) {
            return null;
        }
        return CraftChatMessage.fromJSONOrNull((String)FormattedTextHelper.componentToJson((BaseComponent[])spigot));
    }

    public String updateLegacyName(Class<?> type, String legacyName) {
        return FieldRename.rename((ApiVersion)ApiVersion.FIELD_NAME_PARITY, (String)DebugInternals.getFullClassNameOpti(type).replace('.', '/'), (String)legacyName);
    }

    static {
        AbstractContainerMenu_title_SETTER = ReflectionHelper.getFinalSetter(Container.class, (String)"title");
        ENTITY_BUKKITYENTITY = ReflectionHelper.getFields(Entity.class).get((Object)"bukkitEntity");
        Class<?> minecraftInv = null;
        Field title = null;
        try {
            for (Class<?> clzz : CraftInventoryCustom.class.getDeclaredClasses()) {
                if (!CoreUtilities.toLowerCase((String)clzz.getName()).contains("minecraftinventory")) continue;
                minecraftInv = clzz;
                title = clzz.getDeclaredField("title");
                title.setAccessible(true);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MINECRAFT_INVENTORY = minecraftInv;
        INVENTORY_TITLE = title;
        BOSSBAR_ID_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BossBattle.class, UUID.class);
    }
}

