/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.PacketHelper;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.scripts.commands.entity.TeleportCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundGameTestHighlightPosPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.spider.EntityCaveSpider;
import net.minecraft.world.entity.monster.spider.EntitySpider;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapCanvas;
import org.bukkit.craftbukkit.v1_21_R7.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;

public class PacketHelperImpl
implements PacketHelper {
    public static final DataWatcherObject<Float> PLAYER_DATA_ACCESSOR_ABSORPTION = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityHuman.class, (String)ReflectionMappingsInfo.Player_DATA_PLAYER_ABSORPTION_ID, null);
    public static final DataWatcherObject<Byte> ENTITY_DATA_ACCESSOR_FLAGS = (DataWatcherObject)ReflectionHelper.getFieldValue(net.minecraft.world.entity.Entity.class, (String)ReflectionMappingsInfo.Entity_DATA_SHARED_FLAGS_ID, null);
    public static final MethodHandle ABILITIES_PACKET_FOV_SETTER = ReflectionHelper.getFinalSetter(PacketPlayOutAbilities.class, (String)ReflectionMappingsInfo.ClientboundPlayerAbilitiesPacket_walkingSpeed);
    public static final Field ENTITY_TRACKER_ENTRY_GETTER = ReflectionHelper.getFields(PlayerChunkMap.EntityTracker.class).getFirstOfType(EntityTrackerEntry.class);
    public static final MethodHandle CANVAS_GET_BUFFER = ReflectionHelper.getMethodHandle(CraftMapCanvas.class, (String)"getBuffer", (Class[])new Class[0]);
    public static final Field MAPVIEW_WORLDMAP = ReflectionHelper.getFields(CraftMapView.class).get("worldMap");
    public static final DataWatcherObject<Optional<IChatBaseComponent>> ENTITY_DATA_ACCESSOR_CUSTOM_NAME = (DataWatcherObject)ReflectionHelper.getFieldValue(net.minecraft.world.entity.Entity.class, (String)ReflectionMappingsInfo.Entity_DATA_CUSTOM_NAME, null);
    public static final DataWatcherObject<Boolean> ENTITY_DATA_ACCESSOR_CUSTOM_NAME_VISIBLE = (DataWatcherObject)ReflectionHelper.getFieldValue(net.minecraft.world.entity.Entity.class, (String)ReflectionMappingsInfo.Entity_DATA_CUSTOM_NAME_VISIBLE, null);
    public static HashMap<UUID, HashMap<UUID, ScoreboardTeam>> noCollideTeamMap = new HashMap();

    public void setFakeAbsorption(Player player, float value) {
        PacketHelperImpl.send(player, new PacketPlayOutEntityMetadata(player.getEntityId(), List.of(PacketHelperImpl.createEntityData(PLAYER_DATA_ACCESSOR_ABSORPTION, Float.valueOf(value)))));
    }

    public void setSlot(Player player, int slot, ItemStack itemStack, boolean playerOnly) {
        Container menu = ((CraftPlayer)player).getHandle().cn;
        int windowId = playerOnly ? 0 : menu.l;
        PacketHelperImpl.send(player, new PacketPlayOutSetSlot(windowId, menu.k(), slot, CraftItemStack.asNMSCopy((ItemStack)itemStack)));
    }

    public void setFieldOfView(Player player, float fov) {
        PacketPlayOutAbilities packet = new PacketPlayOutAbilities(((CraftPlayer)player).getHandle().gL());
        if (!Float.isNaN(fov)) {
            try {
                ABILITIES_PACKET_FOV_SETTER.invoke(packet, fov);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        PacketHelperImpl.send(player, packet);
    }

    public void respawn(Player player) {
        ((CraftPlayer)player).getHandle().g.a(new PacketPlayInClientCommand(PacketPlayInClientCommand.EnumClientCommand.a));
    }

    public void setVision(Player player, EntityType entityType) {
        EntityCreeper entity;
        if (entityType == EntityType.CREEPER) {
            entity = new EntityCreeper(EntityTypes.I, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.SPIDER) {
            entity = new EntitySpider(EntityTypes.bw, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.CAVE_SPIDER) {
            entity = new EntityCaveSpider(EntityTypes.y, (World)((CraftWorld)player.getWorld()).getHandle());
        } else if (entityType == EntityType.ENDERMAN) {
            entity = new EntityEnderman(EntityTypes.R, (World)((CraftWorld)player.getWorld()).getHandle());
        } else {
            return;
        }
        PacketHelperImpl.send(player, new PacketPlayOutSpawnEntity((net.minecraft.world.entity.Entity)entity, 0, BlockPosition.c));
        PacketHelperImpl.send(player, new PacketPlayOutCamera((net.minecraft.world.entity.Entity)entity));
        NMSHandler.playerHelper.refreshPlayer(player);
        PacketHelperImpl.send(player, new PacketPlayOutEntityDestroy(new int[]{entity.aA()}));
    }

    public void showBlockAction(Player player, Location location, int action, int state) {
        BlockPosition position = CraftLocation.toBlockPosition((Location)location);
        Block block = ((CraftWorld)location.getWorld()).getHandle().a_(position).b();
        PacketHelperImpl.send(player, new PacketPlayOutBlockAction(position, block, action, state));
    }

    public void showTabListHeaderFooter(Player player, String header, String footer) {
        IChatBaseComponent cHeader = Handler.componentToNMS(FormattedTextHelper.parse((String)header, (ChatColor)ChatColor.WHITE));
        IChatBaseComponent cFooter = Handler.componentToNMS(FormattedTextHelper.parse((String)footer, (ChatColor)ChatColor.WHITE));
        PacketHelperImpl.send(player, new PacketPlayOutPlayerListHeaderFooter(cHeader, cFooter));
    }

    public void showTitle(Player player, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        PacketHelperImpl.send(player, new ClientboundBundlePacket(List.of(new ClientboundSetTitlesAnimationPacket(fadeInTicks, stayTicks, fadeOutTicks), new ClientboundSetTitleTextPacket(Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.WHITE))), new ClientboundSetSubtitleTextPacket(Handler.componentToNMS(FormattedTextHelper.parse((String)subtitle, (ChatColor)ChatColor.WHITE))))));
    }

    public void showMobHealth(Player player, LivingEntity mob, double health, double maxHealth) {
        AttributeModifiable attr = new AttributeModifiable(GenericAttributes.u, a2 -> {});
        attr.a(maxHealth);
        PacketHelperImpl.send(player, new PacketPlayOutUpdateAttributes(mob.getEntityId(), List.of(attr)));
        PacketHelperImpl.send(player, new PacketPlayOutEntityMetadata(mob.getEntityId(), List.of(PacketHelperImpl.createEntityData(EntityLiving.cd, Float.valueOf((float)health)))));
    }

    public void showSignEditor(Player player, Location location) {
        NetworkInterceptHelper.enable();
        Sign sign = null;
        BlockPosition toOpen = null;
        for (int i = 0; i < 8; ++i) {
            Sign foundSign;
            Location toCheck = player.getLocation();
            toCheck.setY(toCheck.getY() - (double)i);
            BlockState blockState = toCheck.getBlock().getState();
            if (!(blockState instanceof Sign)) {
                sign = null;
                toOpen = CraftLocation.toBlockPosition((Location)toCheck);
                break;
            }
            sign = foundSign = (Sign)blockState;
        }
        if (sign != null) {
            toOpen = CraftLocation.toBlockPosition((Location)sign.getLocation());
            SignSide front = sign.getSide(Side.FRONT);
            for (int line = 0; line < 4; ++line) {
                front.setLine(line, "");
            }
            player.sendBlockUpdate(sign.getLocation(), sign);
        } else {
            player.sendBlockChange((Location)new LocationTag(player.getWorld(), (double)toOpen.u(), (double)toOpen.v(), (double)toOpen.w()), Material.OAK_WALL_SIGN.createBlockData());
        }
        DenizenNetworkManagerImpl.getNetworkManager((Player)player).packetListener.fakeSignExpected = toOpen;
        PacketHelperImpl.send(player, new PacketPlayOutOpenSignEditor(toOpen, true));
    }

    public void forceSpectate(Player player, Entity entity) {
        PacketHelperImpl.send(player, new PacketPlayOutCamera(((CraftEntity)entity).getHandle()));
    }

    public static void forceRespawnPlayerEntity(Entity entity, Player viewer) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().ao()).p().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.G.get(entity.getEntityId());
        if (entityTracker != null) {
            try {
                EntityTrackerEntry entry = (EntityTrackerEntry)ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
                if (entry != null) {
                    entry.a(((CraftPlayer)viewer).getHandle());
                    entry.b(((CraftPlayer)viewer).getHandle());
                }
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void sendRename(Player player, Entity entity, String name, boolean listMode) {
        try {
            if (entity.getType() == EntityType.PLAYER) {
                if (listMode) {
                    PacketHelperImpl.send(player, new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.f, ((CraftPlayer)player).getHandle()));
                } else {
                    PacketHelperImpl.forceRespawnPlayerEntity(entity, player);
                }
                return;
            }
            List<DataWatcher.c<Boolean>> list = List.of(PacketHelperImpl.createEntityData(ENTITY_DATA_ACCESSOR_CUSTOM_NAME, Optional.of(Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)))), PacketHelperImpl.createEntityData(ENTITY_DATA_ACCESSOR_CUSTOM_NAME_VISIBLE, true));
            PacketHelperImpl.send(player, new PacketPlayOutEntityMetadata(entity.getEntityId(), list));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void generateNoCollideTeam(Player player, UUID noCollide) {
        this.removeNoCollideTeam(player, noCollide);
        ScoreboardTeam team = new ScoreboardTeam(SidebarImpl.dummyScoreboard, Utilities.generateRandomColors((int)8));
        team.h().add(noCollide.toString());
        team.a(ScoreboardTeamBase.EnumTeamPush.b);
        HashMap map = noCollideTeamMap.computeIfAbsent(player.getUniqueId(), k -> new HashMap());
        map.put(noCollide, team);
        PacketHelperImpl.send(player, PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (boolean)true));
    }

    public void removeNoCollideTeam(Player player, UUID noCollide) {
        if (noCollide == null || !player.isOnline()) {
            noCollideTeamMap.remove(player.getUniqueId());
            return;
        }
        HashMap<UUID, ScoreboardTeam> map = noCollideTeamMap.get(player.getUniqueId());
        if (map == null) {
            return;
        }
        ScoreboardTeam team = map.remove(noCollide);
        if (team != null) {
            PacketHelperImpl.send(player, PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team));
        }
        if (map.isEmpty()) {
            noCollideTeamMap.remove(player.getUniqueId());
        }
    }

    public void sendEntityMetadataFlagsUpdate(Player player, Entity entity) {
        byte flags = (Byte)((CraftEntity)entity).getHandle().aD().a(ENTITY_DATA_ACCESSOR_FLAGS);
        PacketHelperImpl.send(player, new PacketPlayOutEntityMetadata(entity.getEntityId(), List.of(PacketHelperImpl.createEntityData(ENTITY_DATA_ACCESSOR_FLAGS, flags))));
    }

    public void sendEntityEffect(Player player, Entity entity, EntityEffect effect) {
        PacketHelperImpl.send(player, new PacketPlayOutEntityStatus(((CraftEntity)entity).getHandle(), effect.getData()));
    }

    public int getPacketStats(Player player, boolean sent) {
        DenizenNetworkManagerImpl netMan = DenizenNetworkManagerImpl.getNetworkManager(player);
        return sent ? netMan.packetsSent : netMan.packetsReceived;
    }

    public void setMapData(MapCanvas canvas, byte[] bytes, int x, int y, MapImage image) {
        if (x > 127 || y > 127) {
            return;
        }
        int width = Math.min(image.width, 128 - x);
        int height = Math.min(image.height, 128 - y);
        if (x + width <= 0 || y + height <= 0) {
            return;
        }
        try {
            int x2;
            boolean anyChanged = false;
            byte[] buffer = CANVAS_GET_BUFFER.invoke(canvas);
            int n = x2 = x < 0 ? -x : 0;
            while (x2 < width) {
                int y2;
                int n2 = y2 = y < 0 ? -y : 0;
                while (y2 < height) {
                    int index;
                    byte p = bytes[y2 * image.width + x2];
                    if (p != 0 && buffer[index = (y2 + y) * 128 + (x2 + x)] != p) {
                        buffer[index] = p;
                        anyChanged = true;
                    }
                    ++y2;
                }
                ++x2;
            }
            if (anyChanged) {
                WorldMap map = (WorldMap)MAPVIEW_WORLDMAP.get(canvas.getMapView());
                map.a(Math.max(x, 0), Math.max(y, 0));
                map.a(width + x - 1, height + y - 1);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setNetworkManagerFor(Player player) {
        DenizenNetworkManagerImpl.setNetworkManager(player);
    }

    public void enableNetworkManager() {
        DenizenNetworkManagerImpl.enableNetworkManager();
    }

    public void showDebugTestMarker(Player player, Location location, ColorTag color, String name, int time) {
        BlockPosition nmsPos = CraftLocation.toBlockPosition((Location)location);
        LocationTag displayPos = !name.isEmpty() ? LocationTag.valueOf((String)name, (TagContext)CoreUtilities.noDebugContext) : null;
        PacketHelperImpl.send(player, new ClientboundGameTestHighlightPosPacket(nmsPos, displayPos != null ? CraftLocation.toBlockPosition((Location)displayPos) : nmsPos));
    }

    public void clearDebugTestMarker(Player player) {
    }

    public void sendBrand(Player player, String brand) {
        BrandPayload payload = new BrandPayload(brand);
        PacketHelperImpl.send(player, new ClientboundCustomPayloadPacket((CustomPacketPayload)payload));
    }

    public void sendCollectItemEntity(Player player, Entity taker, Entity item, int amount) {
        PacketHelperImpl.send(player, new PacketPlayOutCollect(item.getEntityId(), taker.getEntityId(), amount));
    }

    public Relative toNmsRelativeMovement(TeleportCommand.Relative relative) {
        return switch (relative) {
            default -> throw new IncompatibleClassChangeError();
            case TeleportCommand.Relative.X -> Relative.a;
            case TeleportCommand.Relative.Y -> Relative.b;
            case TeleportCommand.Relative.Z -> Relative.c;
            case TeleportCommand.Relative.YAW -> Relative.d;
            case TeleportCommand.Relative.PITCH -> Relative.e;
        };
    }

    public void sendRelativePositionPacket(Player player, double x, double y, double z, float yaw, float pitch, List<TeleportCommand.Relative> relativeAxis) {
        EnumSet<Relative> relativeMovements;
        if (relativeAxis == null) {
            relativeMovements = Relative.j;
        } else {
            relativeMovements = EnumSet.noneOf(Relative.class);
            for (TeleportCommand.Relative relative : relativeAxis) {
                relativeMovements.add(this.toNmsRelativeMovement(relative));
            }
        }
        PacketPlayOutPosition packet = new PacketPlayOutPosition(0, new PositionMoveRotation(new Vec3D(x, y, z), Vec3D.c, yaw, pitch), relativeMovements);
        PacketHelperImpl.sendAsyncSafe(player, packet);
    }

    public void sendRelativeLookPacket(Player player, float yaw, float pitch) {
        this.sendRelativePositionPacket(player, 0.0, 0.0, 0.0, yaw, pitch, null);
    }

    public void sendEntityDataPacket(List<Player> players, Entity entity, List<Object> data) {
        PacketPlayOutEntityMetadata setEntityDataPacket = new PacketPlayOutEntityMetadata(entity.getEntityId(), data);
        Iterator<Player> playerIterator = players.iterator();
        while (playerIterator.hasNext()) {
            Player player = playerIterator.next();
            if (!DenizenNetworkManagerImpl.getConnection(player).i()) {
                playerIterator.remove();
                continue;
            }
            PacketHelperImpl.sendAsyncSafe(player, setEntityDataPacket);
        }
    }

    public static void send(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().g.b(packet);
    }

    public static void broadcast(Packet<?> packet) {
        ((CraftServer)Bukkit.getServer()).getHandle().a(packet);
    }

    public static void sendAsyncSafe(Player player, Packet<?> packet) {
        DenizenNetworkManagerImpl.getConnection((Player)player).k.writeAndFlush(packet);
    }

    public static <T> DataWatcher.c<T> createEntityData(DataWatcherObject<T> accessor, T value) {
        return new DataWatcher.c(accessor.a(), accessor.b(), value);
    }
}

