/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;

public class EntityBreedScriptEvent
extends BukkitScriptEvent
implements Listener {
    private EntityTag entity;
    private EntityTag breeder;
    private EntityTag father;
    private EntityTag mother;
    private ItemTag item;
    private int experience;
    public EntityBreedEvent event;

    public EntityBreedScriptEvent() {
        this.registerCouldMatcher("<entity> breeds");
        this.registerOptionalDetermination(null, ElementTag.class, (evt, context, determination) -> {
            if (determination.isInt()) {
                evt.event.setExperience(determination.asInt());
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.entity)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "child" -> this.entity.getDenizenObject();
            case "breeder" -> {
                if (this.breeder == null) {
                    yield null;
                }
                yield this.breeder.getDenizenObject();
            }
            case "father" -> this.father.getDenizenObject();
            case "mother" -> this.mother.getDenizenObject();
            case "item" -> this.item;
            case "experience" -> new ElementTag(this.experience);
            default -> super.getContext(name);
        };
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled && this.entity.getBukkitEntity() instanceof Animals) {
            ((Animals)this.father.getLivingEntity()).setLoveModeTicks(0);
            ((Animals)this.mother.getLivingEntity()).setLoveModeTicks(0);
        } else if (this.cancelled && this.entity.getBukkitEntity() instanceof Villager) {
            ((Villager)this.father.getLivingEntity()).getInventory().clear();
            ((Villager)this.mother.getLivingEntity()).getInventory().clear();
        }
        super.cancellationChanged();
    }

    @EventHandler
    public void onEntityBreeds(EntityBreedEvent event) {
        LivingEntity entity = event.getEntity();
        this.entity = new EntityTag((Entity)entity);
        this.breeder = event.getBreeder() == null ? null : new EntityTag((Entity)event.getBreeder());
        this.father = new EntityTag((Entity)event.getFather());
        this.mother = new EntityTag((Entity)event.getMother());
        this.item = event.getBredWith() == null ? null : new ItemTag(event.getBredWith());
        this.experience = event.getExperience();
        this.event = event;
        EntityTag.rememberEntity((Entity)entity);
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)entity);
    }
}

