/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizen.utilities.maps.MapObject;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.Map;
import java.util.UUID;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapView;

public class MapDot
extends MapObject {
    protected String radiusTag;
    protected String colorTag;

    public MapDot(String xTag, String yTag, String visibilityTag, boolean debug, String radiusTag, String colorTag) {
        super(xTag, yTag, visibilityTag, debug);
        this.radiusTag = radiusTag;
        this.colorTag = colorTag;
    }

    @Override
    public Map<String, Object> getSaveData() {
        Map<String, Object> data = super.getSaveData();
        data.put("type", "DOT");
        data.put("radius", this.radiusTag);
        data.put("color", this.colorTag);
        return data;
    }

    @Override
    public void render(MapView mapView, MapCanvas mapCanvas, PlayerTag player, UUID uuid) {
        try {
            int baseX = this.getX(player);
            int baseY = this.getY(player);
            int radius = (int)Double.parseDouble(this.tag(this.radiusTag, player));
            ColorTag color = ColorTag.valueOf(this.tag(this.colorTag, player), this.getTagContext(player));
            byte colorId = MapImage.matchColor(color.getAWTColor());
            int max = radius == 0 ? 1 : radius;
            for (int x = -radius; x < max; ++x) {
                int finalX = baseX + x;
                if (finalX < 0 || finalX > 127) continue;
                for (int y = -radius; y < max; ++y) {
                    int finalY = baseY + y;
                    if (finalY < 0 || finalY > 127 || !(((double)x + 0.5) * ((double)x + 0.5) + ((double)y + 0.5) * ((double)y + 0.5) <= (double)(max * max))) continue;
                    mapCanvas.setPixel(finalX, finalY, colorId);
                }
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }
}

