/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerFishesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag hook;
    public ElementTag state;
    public EntityTag entity;
    public ItemTag item;
    public PlayerFishEvent event;

    public PlayerFishesScriptEvent() {
        this.registerCouldMatcher("player fishes (<entity>) (while <'state'>)");
        this.registerCouldMatcher("player fishes (<item>) (while <'state'>)");
        this.registerSwitches("with");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String fish = path.eventArgLowerAt(2);
        if (!(fish.isEmpty() || fish.equals("in") || fish.equals("while"))) {
            if (this.entity == null) {
                return false;
            }
            if (!this.entity.tryAdvancedMatcher(fish, path.context)) {
                if (this.item == null) {
                    return false;
                }
                if (!this.item.tryAdvancedMatcher(fish, path.context)) {
                    return false;
                }
            }
        }
        String[] data = path.eventArgsLower;
        for (int index = 2; index < data.length; ++index) {
            if (!data[index].equals("while") || data[index + 1].equalsIgnoreCase(this.state.asString())) continue;
            return false;
        }
        if (!this.runInCheck(path, this.hook.getLocation())) {
            return false;
        }
        if (path.switches.containsKey("with")) {
            if (!EntityTag.isPlayer((Entity)this.event.getPlayer())) {
                return false;
            }
            ItemStack held = this.event.getPlayer().getEquipment().getItemInMainHand();
            if (held.getType() != Material.FISHING_ROD) {
                held = this.event.getPlayer().getEquipment().getItemInOffHand();
            }
            if (!PlayerFishesScriptEvent.runWithCheck(path, new ItemTag(held))) {
                return false;
            }
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String determinationLower = CoreUtilities.toLowerCase(determination);
            if (determinationLower.startsWith("caught:")) {
                Entity entity;
                this.item = ItemTag.valueOf(determination.substring("caught:".length()), this.getTagContext(path));
                if (this.entity != null && (entity = this.entity.getBukkitEntity()) instanceof Item) {
                    Item itemEnt = (Item)entity;
                    itemEnt.setItemStack(this.item.getItemStack());
                    return true;
                }
            } else if (determinationLower.startsWith("xp:")) {
                int newXP = new ElementTag(determination.substring("xp:".length())).asInt();
                this.event.setExpToDrop(newXP);
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(EntityTag.isPlayer((Entity)this.event.getPlayer()) ? EntityTag.getPlayerFrom((Entity)this.event.getPlayer()) : (EntityTag.isPlayer(this.event.getCaught()) ? EntityTag.getPlayerFrom(this.event.getCaught()) : null), EntityTag.isCitizensNPC((Entity)this.event.getPlayer()) ? EntityTag.getNPCFrom((Entity)this.event.getPlayer()) : (EntityTag.isCitizensNPC(this.event.getCaught()) ? EntityTag.getNPCFrom(this.event.getCaught()) : null));
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("hook")) {
            return this.hook;
        }
        if (name.equals("entity") && this.entity != null) {
            return this.entity.getDenizenObject();
        }
        if (name.equals("item") && this.item != null) {
            return this.item;
        }
        if (name.equals("state")) {
            return this.state;
        }
        if (name.equals("xp")) {
            return new ElementTag(this.event.getExpToDrop());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onPlayerFishes(PlayerFishEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        FishHook hookEntity = event.getHook();
        EntityTag.rememberEntity((Entity)hookEntity);
        this.hook = new EntityTag((Entity)hookEntity);
        this.state = new ElementTag(event.getState().toString());
        this.item = null;
        this.entity = null;
        Entity caughtEntity = event.getCaught();
        if (caughtEntity != null) {
            EntityTag.rememberEntity(caughtEntity);
            this.entity = new EntityTag(caughtEntity);
            if (caughtEntity instanceof Item) {
                this.item = new ItemTag(((Item)caughtEntity).getItemStack());
            }
        }
        this.event = event;
        this.fire((Event)event);
        EntityTag.forgetEntity((Entity)hookEntity);
        EntityTag.forgetEntity(caughtEntity);
    }
}

