/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.inventory.InventoryViewUtil;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerDragsInInvScriptEvent
extends BukkitScriptEvent
implements Listener {
    public Inventory inventory;
    public ItemTag item;
    private PlayerTag entity;
    private InventoryTag dInv;
    public InventoryDragEvent event;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("player drags");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String inv;
        String arg2 = path.eventArgLowerAt(2);
        String arg3 = path.eventArgLowerAt(3);
        String arg4 = path.eventArgLowerAt(4);
        String string = arg2.equals("in") ? arg3 : (inv = arg3.equals("in") ? arg4 : "");
        if (!inv.equals("") && !this.dInv.tryAdvancedMatcher(inv, path.context)) {
            return false;
        }
        if (!arg2.equals("in") && !this.item.tryAdvancedMatcher(arg2, path.context)) {
            return false;
        }
        if (!this.runInCheck(path, this.entity.getLocation(), "in_area")) {
            return false;
        }
        if (!PlayerDragsInInvScriptEvent.runGenericSwitchCheck(path, "drag_type", this.event.getType().name())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity, null);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "inventory": {
                return this.dInv;
            }
            case "slots": {
                ListTag slots = new ListTag();
                for (Integer slot : this.event.getInventorySlots()) {
                    slots.add(String.valueOf(slot + 1));
                }
                return slots;
            }
            case "raw_slots": {
                ListTag raw_slots = new ListTag();
                for (Integer raw_slot : this.event.getRawSlots()) {
                    raw_slots.add(String.valueOf(raw_slot + 1));
                }
                return raw_slots;
            }
            case "item": {
                return this.item;
            }
            case "clicked_inventory": {
                return InventoryTag.mirrorBukkitInventory(InventoryViewUtil.getInventory(this.event.getView(), this.event.getRawSlots().stream().findFirst().orElse(0)));
            }
            case "drag_type": {
                return new ElementTag((Enum<?>)this.event.getType());
            }
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled) {
            final InventoryHolder holder = this.inventory.getHolder();
            new BukkitRunnable(){

                public void run() {
                    PlayerDragsInInvScriptEvent.this.entity.getPlayerEntity().updateInventory();
                    if (holder instanceof Player) {
                        ((Player)holder).updateInventory();
                    }
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), 1L);
        }
        super.cancellationChanged();
    }

    @EventHandler
    public void onPlayerDragsInInv(InventoryDragEvent event) {
        if (EntityTag.isCitizensNPC((Entity)event.getWhoClicked())) {
            return;
        }
        this.entity = EntityTag.getPlayerFrom((Entity)event.getWhoClicked());
        this.inventory = event.getInventory();
        this.dInv = InventoryTag.mirrorBukkitInventory(this.inventory);
        this.item = new ItemTag(event.getOldCursor());
        this.event = event;
        this.fire((Event)event);
    }
}

