/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;

public class PlaySoundCommand
extends AbstractCommand {
    public PlaySoundCommand() {
        this.setName("playsound");
        this.setSyntax("playsound (<location>|...) (<player>|...) [sound:<name>] (volume:<#.#>) (pitch:<#.#>) (custom) (sound_category:<category_name>)");
        this.setRequiredArguments(2, 7);
        this.isProcedural = false;
        this.setBooleansHandled("custom");
        this.setPrefixesHandled("sound_category", "pitch", "volume");
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("sound:", Utilities.listTypes(Sound.class));
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("locations") && arg.matchesArgumentList(LocationTag.class)) {
                scriptEntry.addObject("locations", arg.asType(ListTag.class).filter(LocationTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(PlayerTag.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("sound") && arg.limitToOnlyPrefix("sound")) {
                scriptEntry.addObject("sound", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("sound")) {
            throw new InvalidArgumentsException("Missing sound argument!");
        }
        if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        block18: {
            SoundCategory categoryEnum;
            List locations = (List)scriptEntry.getObject("locations");
            List players = (List)scriptEntry.getObject("entities");
            ElementTag soundElement = scriptEntry.getElement("sound");
            ElementTag volumeElement = scriptEntry.argForPrefixAsElement("volume", "1");
            ElementTag pitchElement = scriptEntry.argForPrefixAsElement("pitch", "1");
            boolean custom = scriptEntry.argAsBoolean("custom");
            ElementTag sound_category = scriptEntry.argForPrefixAsElement("sound_category", "MASTER");
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, this.getName(), PlaySoundCommand.db("locations", locations), PlaySoundCommand.db("entities", players), soundElement, volumeElement, pitchElement, PlaySoundCommand.db("custom", custom));
            }
            String sound = soundElement.asString();
            float volume = volumeElement.asFloat();
            float pitch = pitchElement.asFloat();
            String category = sound_category.asString().toUpperCase();
            SoundCategory soundCategory = categoryEnum = category != null ? new ElementTag(category).asEnum(SoundCategory.class) : null;
            if (categoryEnum == null) {
                categoryEnum = SoundCategory.MASTER;
            }
            try {
                if (players == null) {
                    if (custom) {
                        for (LocationTag location : locations) {
                            location.getWorld().playSound((Location)location, sound, categoryEnum, volume, pitch);
                        }
                    } else {
                        for (LocationTag location : locations) {
                            location.getWorld().playSound((Location)location, Utilities.elementToEnumlike(soundElement, Sound.class), categoryEnum, volume, pitch);
                        }
                    }
                } else if (locations != null) {
                    for (LocationTag location : locations) {
                        for (PlayerTag player : players) {
                            if (custom) {
                                player.getPlayerEntity().playSound((Location)location, sound, categoryEnum, volume, pitch);
                                continue;
                            }
                            player.getPlayerEntity().playSound((Location)location, Utilities.elementToEnumlike(soundElement, Sound.class), categoryEnum, volume, pitch);
                        }
                    }
                } else {
                    for (PlayerTag player : players) {
                        if (custom) {
                            player.getPlayerEntity().playSound((Location)player.getLocation(), sound, categoryEnum, volume, pitch);
                            continue;
                        }
                        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
                            player.getPlayerEntity().playSound((Entity)player.getPlayerEntity(), Utilities.elementToEnumlike(soundElement, Sound.class), categoryEnum, volume, pitch);
                            continue;
                        }
                        player.getPlayerEntity().playSound((Location)player.getLocation(), Utilities.elementToEnumlike(soundElement, Sound.class), categoryEnum, volume, pitch);
                    }
                }
            }
            catch (Exception e) {
                Debug.echoDebug((Debuggable)scriptEntry, "Unable to play sound.");
                if (!CoreConfiguration.debugVerbose) break block18;
                Debug.echoError(e);
            }
        }
    }
}

